/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventConcurrentPhase;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticTraceLevel;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class GcStatisticConcMarkSweepGcImpl
extends GcStatisticImpl
implements GcStatisticConcMarkSweepGc {
    private final int nrOfThreads;
    private final boolean isConcurrent;
    private final boolean isCompactingOld;
    private final long bytesFreedConcurrentlyInOld;
    private final long bytesFreedConcurrentlyInPerm;
    private final long nrOfNonArrayClassesUnloadedConcurrently;
    private final long nrOfArrayClassesUnloadedConcurrently;

    public GcStatisticConcMarkSweepGcImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        super(reader, mapInfo, GcType.CONC_MARK_SWEEP_GC);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = history.isExact();
        boolean[] bools = reader.readBooleanArray();
        this.isConcurrent = bools[0];
        this.isCompactingOld = bools[1];
        this.nrOfThreads = history.getNumberOfGCThreads();
        this.bytesFreedConcurrentlyInOld = reader.readInt64Percentage(this.getMaxOldGenSize(), exact);
        this.bytesFreedConcurrentlyInPerm = this.ver() < 1 ? reader.readInt64Percentage(history.getReservedPermGenSize(), exact) : 0L;
        this.nrOfNonArrayClassesUnloadedConcurrently = reader.readCompressedInt64();
        this.nrOfArrayClassesUnloadedConcurrently = reader.readCompressedInt64();
        if (!history.isKeyGC()) {
            this.addCumulativeNrOfUnloadedNonArrayClasses(this.nrOfNonArrayClassesUnloadedConcurrently);
            history.setCumulativeNrOfUnloadedNonArrayClasses(this.getCumulativeNrOfUnloadedNonArrayClasses());
            this.addCumulativeNrOfUnloadedArrayClasses(this.nrOfArrayClassesUnloadedConcurrently);
            history.setCumulativeNrOfUnloadedArrayClasses(this.getCumulativeNrOfUnloadedArrayClasses());
            this.addCumulativeBytesAllocatedInPerm(this.bytesFreedConcurrentlyInPerm);
            history.setCumulativeBytesAllocatedInPerm(this.getCumulativeBytesAllocatedInPerm());
            this.addCumulativeBytesFreedInPerm(this.bytesFreedConcurrentlyInPerm);
            history.setCumulativeBytesFreedInPerm(this.getCumulativeBytesFreedInPerm());
            this.addCumulativeBytesAllocatedInNonPerm(this.bytesFreedConcurrentlyInOld);
            history.setCumulativeBytesAllocatedInNonPerm(this.getCumulativeBytesAllocatedInNonPerm());
            this.addCumulativeBytesFreedInNonPerm(this.bytesFreedConcurrentlyInOld);
            history.setCumulativeBytesFreedInNonPerm(this.getCumulativeBytesFreedInNonPerm());
        }
        if (this.isConcurrent) {
            mapInfo.setLastConcurrentGcEnd(this.getLastEventEndTimeStamp());
        }
        this.readClassSpace(reader, mapInfo);
    }

    public GcStatisticConcMarkSweepGcImpl(ResourceReader reader, MappingInformation mapInfo, int dummy) throws IOException {
        super(reader, mapInfo, GcType.CONC_MARK_SWEEP_GC, dummy);
        this.nrOfThreads = reader.readInt32();
        this.isConcurrent = reader.readBoolean();
        this.isCompactingOld = reader.readBoolean();
        this.bytesFreedConcurrentlyInOld = reader.readInt64();
        this.bytesFreedConcurrentlyInPerm = this.ver() < 1 ? reader.readInt64() : 0L;
        this.nrOfNonArrayClassesUnloadedConcurrently = reader.readInt64();
        this.nrOfArrayClassesUnloadedConcurrently = reader.readInt64();
        if (this.isConcurrent) {
            mapInfo.setLastConcurrentGcEnd(this.getLastEventEndTimeStamp());
        }
        this.readClassSpace(reader, mapInfo, dummy);
    }

    public static GcStatisticConcMarkSweepGcImpl read(ResourceReader reader, GcEventHandler[] handlers, MappingInformation mapInfo, boolean withEvents) throws IOException {
        GcStatisticConcMarkSweepGcImpl result;
        if (withEvents) {
            result = new GcStatisticConcMarkSweepGcImpl(reader, mapInfo, 0);
        } else {
            result = new GcStatisticConcMarkSweepGcImpl(reader, mapInfo);
            if (GcStatisticConcMarkSweepGcImpl.skipGcStatistic(result)) {
                return null;
            }
        }
        for (GcEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        if (GcStatisticTraceLevel.getCurrentLevel() == GcStatisticTraceLevel.FULL) {
            stream.println("Collection was fully concurrent         : " + (this.isConcurrent ? "yes" : "no"));
            stream.println("Collection has compacted old gen        : " + (this.isCompactingOld ? "yes" : "no"));
            stream.println("Number of parallel GC threads           : " + this.nrOfThreads);
            stream.formatln("Bytes concurrently freed in old         : %*B", this.bytesFreedConcurrentlyInOld);
            if (this.ver() < 1) {
                stream.formatln("Bytes concurrently freed in perm        : %*B", this.bytesFreedConcurrentlyInPerm);
            }
            stream.println("Non-arr. classes concurrently unloaded  : " + this.nrOfNonArrayClassesUnloadedConcurrently);
            stream.println("Array classes concurrently unloaded     : " + this.nrOfArrayClassesUnloadedConcurrently);
        }
        this.printEvents(stream);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)697);
        super.write(writer);
        writer.writeInt32(this.nrOfThreads);
        writer.writeBoolean(this.isConcurrent);
        writer.writeBoolean(this.isCompactingOld);
        writer.writeInt64(this.bytesFreedConcurrentlyInOld);
        if (this.ver() < 1) {
            writer.writeInt64(this.bytesFreedConcurrentlyInPerm);
        }
        writer.writeInt64(this.nrOfNonArrayClassesUnloadedConcurrently);
        writer.writeInt64(this.nrOfArrayClassesUnloadedConcurrently);
        this.writeClassSpace(writer);
        writer.finalizePacket();
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public boolean isCompactingOld() {
        return this.isCompactingOld;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public long getBytesFreedConcurrentlyInOld() {
        return this.bytesFreedConcurrentlyInOld;
    }

    @Override
    public long getBytesFreedConcurrentlyInPerm() {
        return this.bytesFreedConcurrentlyInPerm;
    }

    @Override
    public long getNrOfNonArrayClassesUnloadedConcurrently() {
        return this.nrOfNonArrayClassesUnloadedConcurrently;
    }

    @Override
    public long getNrOfArrayClassesUnloadedConcurrently() {
        return this.nrOfArrayClassesUnloadedConcurrently;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.GC_STATISTIC_CONC_MARK_SWEEP_GC_EVENT;
    }

    @Override
    public long getMaxStopTheWorldDuration() {
        if (!this.isConcurrent) {
            return super.getMaxStopTheWorldDuration();
        }
        long result = 0L;
        for (GcEventBase event : this.getEvents()) {
            GcEventConcurrentPhase phase;
            if (!(event instanceof GcEventConcurrentPhase) || (phase = (GcEventConcurrentPhase)event).isConcurrent()) continue;
            result = Math.max(result, phase.getDuration());
        }
        return result;
    }

    @Override
    public String getPacketName() {
        return "CMS GC event";
    }
}

