/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventConcurrentPhase;
import com.sap.jvm.profiling.memory.event.GcEventG1IncrementalGc;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcG1CollectionSet;
import com.sap.jvm.profiling.memory.event.GcG1YoungListTargetSelReason;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcStatisticTraceLevel;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class GcStatisticG1GcImpl
extends GcStatisticImpl
implements GcStatisticG1Gc {
    private final int nrOfScavengeThreads;
    private final boolean isConcurrent;
    private final long bytesFreedConcurrently;
    private final long nrOfNonArrayClassesUnloadedConcurrently;
    private final long nrOfArrayClassesUnloadedConcurrently;
    private final long humongousRegionsBeforeGc;
    private final long humongousRegionsAfterGc;
    private final long humongousStartRegionsBeforeGc;
    private final long humongousStartRegionsAfterGc;
    private final long committedRegionsBeforeGc;
    private final long committedRegionsAfterGc;
    private final long freeRegionsBeforeGc;
    private final long freeRegionsAfterGc;
    private final long youngRegionsBeforeGc;
    private final long youngRegionsAfterGc;
    private final long survivorRegionsBeforeGc;
    private final long survivorRegionsAfterGc;
    private final long youngListTargetBeforeGc;
    private final long youngListTargetAfterGc;
    private final long youngListMaximumBeforeGc;
    private final long youngListMaximumAfterGc;
    private final GcG1YoungListTargetSelReason youngListTargetSelReason;
    private long heapRegionSize;
    private long maxHeapRegionNum;

    public GcStatisticG1GcImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        super(reader, mapInfo, GcType.GARBAGE_FIRST_GC);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        this.heapRegionSize = history.getHeapRegionSize();
        this.maxHeapRegionNum = history.getMaxHeapRegionNum();
        boolean exact = history.isExact();
        boolean[] bools = reader.readBooleanArray();
        this.isConcurrent = bools[0];
        this.nrOfScavengeThreads = history.getNumberOfGCThreads();
        this.bytesFreedConcurrently = reader.readInt64Percentage(this.getMaxOldGenSize(), exact);
        this.nrOfNonArrayClassesUnloadedConcurrently = this.ver() > 0 ? reader.readCompressedInt64() : 0L;
        long l = this.nrOfArrayClassesUnloadedConcurrently = this.ver() > 0 ? reader.readCompressedInt64() : 0L;
        if (!history.isKeyGC()) {
            this.addCumulativeNrOfUnloadedNonArrayClasses(this.nrOfNonArrayClassesUnloadedConcurrently);
            history.setCumulativeNrOfUnloadedNonArrayClasses(this.getCumulativeNrOfUnloadedNonArrayClasses());
            this.addCumulativeNrOfUnloadedArrayClasses(this.nrOfArrayClassesUnloadedConcurrently);
            history.setCumulativeNrOfUnloadedArrayClasses(this.getCumulativeNrOfUnloadedArrayClasses());
            this.addCumulativeBytesAllocatedInNonPerm(this.bytesFreedConcurrently);
            history.setCumulativeBytesAllocatedInNonPerm(this.getCumulativeBytesAllocatedInNonPerm());
            this.addCumulativeBytesFreedInNonPerm(this.bytesFreedConcurrently);
            history.setCumulativeBytesFreedInNonPerm(this.getCumulativeBytesFreedInNonPerm());
        }
        if (this.isConcurrent) {
            mapInfo.setLastConcurrentGcEnd(this.getLastEventEndTimeStamp());
        }
        this.readClassSpace(reader, mapInfo);
        if (reader.hasNext()) {
            this.humongousRegionsBeforeGc = reader.readCompressedInt64();
            this.humongousRegionsAfterGc = reader.readCompressedInt64();
            if (reader.hasNext()) {
                this.humongousStartRegionsBeforeGc = reader.readCompressedInt64();
                this.humongousStartRegionsAfterGc = reader.readCompressedInt64();
                this.youngRegionsBeforeGc = reader.readCompressedInt64();
                this.youngRegionsAfterGc = reader.readCompressedInt64();
                this.survivorRegionsBeforeGc = reader.readCompressedInt64();
                this.survivorRegionsAfterGc = reader.readCompressedInt64();
                this.youngListTargetBeforeGc = reader.readCompressedInt64();
                this.youngListTargetAfterGc = reader.readCompressedInt64();
                this.youngListMaximumBeforeGc = reader.readCompressedInt64();
                this.youngListMaximumAfterGc = reader.readCompressedInt64();
                this.committedRegionsBeforeGc = reader.readCompressedInt64();
                this.committedRegionsAfterGc = reader.readCompressedInt64();
                this.freeRegionsBeforeGc = reader.readCompressedInt64();
                this.freeRegionsAfterGc = reader.readCompressedInt64();
                byte tmp = reader.readInt8();
                this.youngListTargetSelReason = GcG1YoungListTargetSelReason.get(tmp);
            } else {
                this.humongousStartRegionsBeforeGc = 0L;
                this.humongousStartRegionsAfterGc = 0L;
                this.committedRegionsBeforeGc = 0L;
                this.committedRegionsAfterGc = 0L;
                this.freeRegionsBeforeGc = 0L;
                this.freeRegionsAfterGc = 0L;
                this.youngRegionsBeforeGc = 0L;
                this.youngRegionsAfterGc = 0L;
                this.survivorRegionsBeforeGc = 0L;
                this.survivorRegionsAfterGc = 0L;
                this.youngListTargetBeforeGc = 0L;
                this.youngListTargetAfterGc = 0L;
                this.youngListMaximumBeforeGc = 0L;
                this.youngListMaximumAfterGc = 0L;
                this.youngListTargetSelReason = GcG1YoungListTargetSelReason.get(0);
            }
        } else {
            this.humongousRegionsBeforeGc = 0L;
            this.humongousRegionsAfterGc = 0L;
            this.humongousStartRegionsBeforeGc = 0L;
            this.humongousStartRegionsAfterGc = 0L;
            this.committedRegionsBeforeGc = 0L;
            this.committedRegionsAfterGc = 0L;
            this.freeRegionsBeforeGc = 0L;
            this.freeRegionsAfterGc = 0L;
            this.youngRegionsBeforeGc = 0L;
            this.youngRegionsAfterGc = 0L;
            this.survivorRegionsBeforeGc = 0L;
            this.survivorRegionsAfterGc = 0L;
            this.youngListTargetBeforeGc = 0L;
            this.youngListTargetAfterGc = 0L;
            this.youngListMaximumBeforeGc = 0L;
            this.youngListMaximumAfterGc = 0L;
            this.youngListTargetSelReason = GcG1YoungListTargetSelReason.get(0);
        }
    }

    public GcStatisticG1GcImpl(ResourceReader reader, MappingInformation mapInfo, int dummy) throws IOException {
        super(reader, mapInfo, GcType.GARBAGE_FIRST_GC, dummy);
        this.nrOfScavengeThreads = reader.readInt32();
        this.isConcurrent = reader.readBoolean();
        this.bytesFreedConcurrently = reader.readInt64();
        this.nrOfNonArrayClassesUnloadedConcurrently = this.ver() > 0 ? reader.readInt64() : 0L;
        long l = this.nrOfArrayClassesUnloadedConcurrently = this.ver() > 0 ? reader.readInt64() : 0L;
        if (this.isConcurrent) {
            mapInfo.setLastConcurrentGcEnd(this.getLastEventEndTimeStamp());
        }
        this.readClassSpace(reader, mapInfo, dummy);
        if (reader.hasNext()) {
            this.humongousRegionsBeforeGc = reader.readInt64();
            this.humongousRegionsAfterGc = reader.readInt64();
            if (reader.hasNext()) {
                this.humongousStartRegionsBeforeGc = reader.readInt64();
                this.humongousStartRegionsAfterGc = reader.readInt64();
                this.youngRegionsBeforeGc = reader.readInt64();
                this.youngRegionsAfterGc = reader.readInt64();
                this.survivorRegionsBeforeGc = reader.readInt64();
                this.survivorRegionsAfterGc = reader.readInt64();
                this.youngListTargetBeforeGc = reader.readInt64();
                this.youngListTargetAfterGc = reader.readInt64();
                this.youngListMaximumBeforeGc = reader.readInt64();
                this.youngListMaximumAfterGc = reader.readInt64();
                this.committedRegionsBeforeGc = reader.readInt64();
                this.committedRegionsAfterGc = reader.readInt64();
                this.freeRegionsBeforeGc = reader.readInt64();
                this.freeRegionsAfterGc = reader.readInt64();
                this.youngListTargetSelReason = GcG1YoungListTargetSelReason.get(reader.readInt8());
            } else {
                this.humongousStartRegionsBeforeGc = 0L;
                this.humongousStartRegionsAfterGc = 0L;
                this.committedRegionsBeforeGc = 0L;
                this.committedRegionsAfterGc = 0L;
                this.freeRegionsBeforeGc = 0L;
                this.freeRegionsAfterGc = 0L;
                this.youngRegionsBeforeGc = 0L;
                this.youngRegionsAfterGc = 0L;
                this.survivorRegionsBeforeGc = 0L;
                this.survivorRegionsAfterGc = 0L;
                this.youngListTargetBeforeGc = 0L;
                this.youngListTargetAfterGc = 0L;
                this.youngListMaximumBeforeGc = 0L;
                this.youngListMaximumAfterGc = 0L;
                this.youngListTargetSelReason = GcG1YoungListTargetSelReason.get(0);
            }
        } else {
            this.humongousRegionsBeforeGc = 0L;
            this.humongousRegionsAfterGc = 0L;
            this.humongousStartRegionsBeforeGc = 0L;
            this.humongousStartRegionsAfterGc = 0L;
            this.committedRegionsBeforeGc = 0L;
            this.committedRegionsAfterGc = 0L;
            this.freeRegionsBeforeGc = 0L;
            this.freeRegionsAfterGc = 0L;
            this.youngRegionsBeforeGc = 0L;
            this.youngRegionsAfterGc = 0L;
            this.survivorRegionsBeforeGc = 0L;
            this.survivorRegionsAfterGc = 0L;
            this.youngListTargetBeforeGc = 0L;
            this.youngListTargetAfterGc = 0L;
            this.youngListMaximumBeforeGc = 0L;
            this.youngListMaximumAfterGc = 0L;
            this.youngListTargetSelReason = GcG1YoungListTargetSelReason.get(0);
        }
    }

    public static GcStatisticG1GcImpl read(ResourceReader reader, GcEventHandler[] handlers, MappingInformation mapInfo, boolean withEvents) throws IOException {
        GcStatisticG1GcImpl result;
        if (withEvents) {
            result = new GcStatisticG1GcImpl(reader, mapInfo, 0);
        } else {
            result = new GcStatisticG1GcImpl(reader, mapInfo);
            if (GcStatisticG1GcImpl.skipGcStatistic(result)) {
                return null;
            }
        }
        for (GcEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        if (GcStatisticTraceLevel.getCurrentLevel() == GcStatisticTraceLevel.FULL) {
            stream.println("Collection was fully concurrent         : " + (this.isConcurrent ? "yes" : "no"));
            stream.println("Number of parallel GC threads           : " + this.nrOfScavengeThreads);
            stream.formatln("Bytes concurrently freed                : %*B", this.bytesFreedConcurrently);
            if (this.ver() > 0) {
                stream.println("Non-arr. classes concurrently unloaded  : " + this.nrOfNonArrayClassesUnloadedConcurrently);
                stream.println("Array classes concurrently unloaded     : " + this.nrOfArrayClassesUnloadedConcurrently);
            }
            stream.formatln("Number of committed regions before GC   : " + this.committedRegionsBeforeGc + " (%*B total) of a maximum " + this.maxHeapRegionNum + " (%*B total)", this.committedRegionsBeforeGc * this.heapRegionSize, this.maxHeapRegionNum * this.heapRegionSize);
            stream.formatln("Number of committed regions after GC    : " + this.committedRegionsAfterGc + " (%*B total) of a maximum " + this.maxHeapRegionNum + " (%*B total)", this.committedRegionsAfterGc * this.heapRegionSize, this.maxHeapRegionNum * this.heapRegionSize);
            stream.formatln("Number of free regions before GC        : " + this.freeRegionsBeforeGc + " (%*B total)", this.freeRegionsBeforeGc * this.heapRegionSize);
            stream.formatln("Number of free regions after GC         : " + this.freeRegionsAfterGc + " (%*B total)", this.freeRegionsAfterGc * this.heapRegionSize);
            stream.formatln("Number of humongous regions before GC   : " + this.humongousRegionsBeforeGc + " (%*B total)", this.humongousRegionsBeforeGc * this.heapRegionSize);
            stream.formatln("Number of humongous regions after GC    : " + this.humongousRegionsAfterGc + " (%*B total)", this.humongousRegionsAfterGc * this.heapRegionSize);
            stream.formatln("Number of hum. start regions before GC  : " + this.humongousStartRegionsBeforeGc + " (%*B total)", this.humongousStartRegionsBeforeGc * this.heapRegionSize);
            stream.formatln("Number of hum. start regions after GC   : " + this.humongousStartRegionsAfterGc + " (%*B total)", this.humongousStartRegionsAfterGc * this.heapRegionSize);
            stream.formatln("Number of young regions before GC       : " + this.youngRegionsBeforeGc + " (%*B total)", this.youngRegionsBeforeGc * this.heapRegionSize);
            stream.formatln("Number of young regions after GC        : " + this.youngRegionsAfterGc + " (%*B total)", this.youngRegionsAfterGc * this.heapRegionSize);
            stream.formatln("Number of survivor regions before GC    : " + this.survivorRegionsBeforeGc + " (%*B total)", this.survivorRegionsBeforeGc * this.heapRegionSize);
            stream.formatln("Number of survivor regions after GC     : " + this.survivorRegionsAfterGc + " (%*B total)", this.survivorRegionsAfterGc * this.heapRegionSize);
            stream.formatln("Target young regions before GC          : " + this.youngListTargetBeforeGc + " (%*B total)", this.youngListTargetBeforeGc * this.heapRegionSize);
            stream.formatln("Target young regions after GC           : " + this.youngListTargetAfterGc + " (%*B total)", this.youngListTargetAfterGc * this.heapRegionSize);
            stream.println("Target young regions selection reason   : " + this.youngListTargetSelReason.getShortDescription());
            stream.formatln("Max young regions before GC             : " + this.youngListMaximumBeforeGc + " (%*B total)", this.youngListMaximumBeforeGc * this.heapRegionSize);
            stream.formatln("Max young regions after GC              : " + this.youngListMaximumAfterGc + " (%*B total)", this.youngListMaximumAfterGc * this.heapRegionSize);
        }
        this.printEvents(stream);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)705);
        super.write(writer);
        writer.writeInt32(this.nrOfScavengeThreads);
        writer.writeBoolean(this.isConcurrent);
        writer.writeInt64(this.bytesFreedConcurrently);
        if (this.ver() > 0) {
            writer.writeInt64(this.nrOfNonArrayClassesUnloadedConcurrently);
            writer.writeInt64(this.nrOfArrayClassesUnloadedConcurrently);
        }
        this.writeClassSpace(writer);
        writer.writeInt64(this.humongousRegionsBeforeGc);
        writer.writeInt64(this.humongousRegionsAfterGc);
        writer.writeInt64(this.humongousStartRegionsBeforeGc);
        writer.writeInt64(this.humongousStartRegionsAfterGc);
        writer.writeInt64(this.youngRegionsBeforeGc);
        writer.writeInt64(this.youngRegionsAfterGc);
        writer.writeInt64(this.survivorRegionsBeforeGc);
        writer.writeInt64(this.survivorRegionsAfterGc);
        writer.writeInt64(this.youngListTargetBeforeGc);
        writer.writeInt64(this.youngListTargetAfterGc);
        writer.writeInt64(this.youngListMaximumBeforeGc);
        writer.writeInt64(this.youngListMaximumAfterGc);
        writer.writeInt64(this.committedRegionsBeforeGc);
        writer.writeInt64(this.committedRegionsAfterGc);
        writer.writeInt64(this.freeRegionsBeforeGc);
        writer.writeInt64(this.freeRegionsAfterGc);
        writer.writeInt8(GcG1YoungListTargetSelReason.get(this.youngListTargetSelReason));
        writer.finalizePacket();
    }

    @Override
    public int getNrOfScavengeThreads() {
        return this.nrOfScavengeThreads;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public long getBytesFreedConcurrently() {
        return this.bytesFreedConcurrently;
    }

    @Override
    public long getNrOfNonArrayClassesUnloadedConcurrently() {
        return this.nrOfNonArrayClassesUnloadedConcurrently;
    }

    @Override
    public long getNrOfArrayClassesUnloadedConcurrently() {
        return this.nrOfArrayClassesUnloadedConcurrently;
    }

    @Override
    public long getCommittedRegionsBeforeGc() {
        return this.committedRegionsBeforeGc;
    }

    @Override
    public long getCommittedRegionsAfterGc() {
        return this.committedRegionsAfterGc;
    }

    @Override
    public long getFreeRegionsBeforeGc() {
        return this.freeRegionsBeforeGc;
    }

    @Override
    public long getFreeRegionsAfterGc() {
        return this.freeRegionsAfterGc;
    }

    @Override
    public long getHumongousRegionsBeforeGc() {
        return this.humongousRegionsBeforeGc;
    }

    @Override
    public long getHumongousRegionsAfterGc() {
        return this.humongousRegionsAfterGc;
    }

    @Override
    public long getHumongousStartRegionsBeforeGc() {
        return this.humongousStartRegionsBeforeGc;
    }

    @Override
    public long getHumongousStartRegionsAfterGc() {
        return this.humongousStartRegionsAfterGc;
    }

    @Override
    public long getYoungRegionsBeforeGc() {
        return this.youngRegionsBeforeGc;
    }

    @Override
    public long getYoungRegionsAfterGc() {
        return this.youngRegionsAfterGc;
    }

    @Override
    public long getSurvivorRegionsBeforeGc() {
        return this.survivorRegionsBeforeGc;
    }

    @Override
    public long getSurvivorRegionsAfterGc() {
        return this.survivorRegionsAfterGc;
    }

    @Override
    public long getYoungListTargetRegionsBeforeGc() {
        return this.youngListTargetBeforeGc;
    }

    @Override
    public long getYoungListTargetRegionsAfterGc() {
        return this.youngListTargetAfterGc;
    }

    @Override
    public long getYoungListMaximumRegionsBeforeGc() {
        return this.youngListMaximumBeforeGc;
    }

    @Override
    public long getYoungListMaximumRegionsAfterGc() {
        return this.youngListMaximumAfterGc;
    }

    @Override
    public GcG1YoungListTargetSelReason getYoungListTargetSelReason() {
        return this.youngListTargetSelReason;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.GC_STATISTIC_GARBAGE_FIRST_GC_EVENT;
    }

    @Override
    public long getMaxStopTheWorldDuration() {
        if (!this.isConcurrent) {
            return super.getMaxStopTheWorldDuration();
        }
        long result = 0L;
        for (GcEventBase event : this.getEvents()) {
            GcEventConcurrentPhase phase;
            if (!(event instanceof GcEventConcurrentPhase) || (phase = (GcEventConcurrentPhase)event).isConcurrent()) continue;
            result = Math.max(result, phase.getDuration());
        }
        return result;
    }

    @Override
    public String getPacketName() {
        return "G1 GC event";
    }

    @Override
    public GcG1CollectionSet getCollectionSet() {
        GcG1CollectionSet res = GcG1CollectionSet.UNKNOWN;
        if (this.isFullGc()) {
            res = GcG1CollectionSet.ALL_FULL_GC;
        } else if (this.isConcurrent()) {
            res = GcG1CollectionSet.ALL_CONC_MARK;
        } else {
            GcEventBase[] events = this.getEvents();
            for (int i = 0; i < events.length; ++i) {
                if (events[i] instanceof GcEventG1IncrementalGc) {
                    res = ((GcEventG1IncrementalGc)events[i]).hasOnlyYoungRegions() ? GcG1CollectionSet.YOUNG : GcG1CollectionSet.MIXED;
                    break;
                }
                if (!(events[i] instanceof GcEventSkippedGcImpl)) continue;
                res = GcG1CollectionSet.NONE;
                break;
            }
        }
        assert (res != GcG1CollectionSet.UNKNOWN);
        return res;
    }
}

