/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcEventAllGenRefHandlingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventClassunloadingPhase1Impl;
import com.sap.jvm.profiling.impl.memory.event.GcEventClassunloadingPhase2Impl;
import com.sap.jvm.profiling.impl.memory.event.GcEventCmsAbortablePrecleaningImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventCmsAbortedImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventCmsFinalMarkingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventCmsInitialMarkingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventCmsMarkingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventCmsPrecleaningImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventCmsSweepingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1BitmapClearingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1CleanupImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1ConcurrentCleanupImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1CountingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1EmptyRegionsReclaimImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1FinalMarkingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1IncrementalGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1InitialMarkingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1MarkSweepGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1MarkingAbortedImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1MarkingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1ParallelFullGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventG1RootScanningImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventOldGenRefHandlingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventParallelGcMarkSweepImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventParallelGcParallelCompactImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventParallelGcScavengeImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventParallelNewGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventParallelSmallGcForcedFullGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventPartialRefHandlingImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSerialNewGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedG1IncrementalGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedG1MarkSweepGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedG1ParallelFullGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedParallelGcMarkSweepImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedParallelGcParallelCompactImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedParallelGcScavengeImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedParallelNewGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedSerialNewGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventSkippedTenuredGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventTenuredGcImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventYoungGenPromotionFailureImpl;
import com.sap.jvm.profiling.impl.memory.event.GcEventYoungGenRefHandlingImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcCause;
import com.sap.jvm.profiling.memory.event.GcDurationEventBase;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventReferenceHandling;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcStatisticTraceLevel;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.Date;

public abstract class GcStatisticImpl
extends ProfilingPacketImpl
implements GcStatistic {
    private final GcType gcType;
    private final GcCause cause;
    private final boolean fullGc;
    private final boolean forcedSoftRefClear;
    private final int nrOfEvents;
    private final GcEventBaseImpl[] gcEvents;
    private final int[] gcEventTypes;
    private final long gcNr;
    private final long nrOfFullGcs;
    private final long timestamp;
    private final long duration;
    private final long cpuTime;
    private final long pageFaults;
    private final long majorPageFaults;
    private final long minorPageFaults;
    private final long allocationGoal;
    private final long nrOfNonArrayClassesBeforeGc;
    private final long nrOfArrayClassesBeforeGc;
    private final long nrOfNonArrayClassesAfterGc;
    private final long nrOfArrayClassesAfterGc;
    private final long bytesInNonPermBeforeGc;
    private final long bytesInNonPermAfterGc;
    private final long bytesInPermBeforeGc;
    private final long bytesInPermAfterGc;
    private final long committedBytesInNonPermBeforeGc;
    private final long committedBytesInNonPermAfterGc;
    private final long committedBytesInPermBeforeGc;
    private final long committedBytesInPermAfterGc;
    private final long maxPermGenSize;
    private final long bytesInEdenBeforeGc;
    private final long bytesInEdenAfterGc;
    private final long committedBytesInEdenBeforeGc;
    private final long committedBytesInEdenAfterGc;
    private final long bytesWastedByTLABsBeforeGc;
    private final long bytesInFromBeforeGc;
    private final long bytesInFromAfterGc;
    private final long committedBytesInFromBeforeGc;
    private final long committedBytesInFromAfterGc;
    private final long bytesInToBeforeGc;
    private final long bytesInToAfterGc;
    private final long committedBytesInToBeforeGc;
    private final long committedBytesInToAfterGc;
    private final long committedBytesInYoungBeforeGc;
    private final long committedBytesInYoungAfterGc;
    private final long maxYoungGenSize;
    private final long bytesInOldBeforeGc;
    private final long bytesInOldAfterGc;
    private final long committedBytesInOldBeforeGc;
    private final long committedBytesInOldAfterGc;
    private final long maxOldGenSize;
    private final int tenuringThreshold;
    private final long cumulativeDuration;
    private final long cumulativeCpuTime;
    private final long cumulativePageFaults;
    private final long cumulativeMajorPageFaults;
    private final long cumulativeMinorPageFaults;
    private long cumulativeNrOfUnloadedNonArrayClasses;
    private long cumulativeNrOfUnloadedArrayClasses;
    private long cumulativeBytesAllocatedInPerm;
    private long cumulativeBytesFreedInPerm;
    private long cumulativeBytesAllocatedInNonPerm;
    private long cumulativeBytesFreedInNonPerm;
    private final long clearedSoftRefsSum;
    private final long enqueuedSoftRefsSum;
    private final long clearedWeakRefsSum;
    private final long enqueuedWeakRefsSum;
    private final long enqueuedFinalRefsSum;
    private final long enqueuedPhantomRefsSum;
    private final boolean exact;
    private final boolean gcNrIsValid;
    private final long millisSinceLastConcGC;
    private long bytesInClassSpaceBeforeGc;
    private long bytesInClassSpaceAfterGc;
    private long committedBytesInClassSpaceBeforeGc;
    private long committedBytesInClassSpaceAfterGc;
    private long maxClassSpaceSize;
    private final byte ver;

    protected GcStatisticImpl(ResourceReader reader, MappingInformation mapInfo, GcType gcType) throws IOException {
        assert (mapInfo.getSession().getSystemInfo().gcStatisticVersion() < 127);
        this.ver = (byte)mapInfo.getSession().getSystemInfo().gcStatisticVersion();
        this.gcType = gcType;
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        this.exact = history.isExact();
        boolean[] bools = reader.readBooleanArray();
        assert (bools.length == 8);
        boolean keyGC = bools[0];
        this.gcNr = keyGC ? reader.readCompressedInt64() : history.getGCNr() + 1L;
        history.setGCNr(this.gcNr, keyGC);
        this.gcNrIsValid = history.hasSeenKeyPacket();
        this.nrOfFullGcs = history.isKeyGC() ? reader.readCompressedInt64() : history.getFullGCNr() + (long)(bools[7] ? 1 : 0);
        history.setFullGCNr(this.nrOfFullGcs);
        this.cause = GcCause.get(reader.readInt8());
        this.fullGc = bools[1];
        this.forcedSoftRefClear = bools[2];
        this.timestamp = reader.readInt64() + history.getStartTimestamp();
        this.duration = reader.readScaledInt32(1000L, this.exact);
        this.cpuTime = reader.readScaledInt32(1000L, this.exact);
        this.pageFaults = reader.readCompressedInt32();
        this.majorPageFaults = reader.readCompressedInt32();
        this.minorPageFaults = reader.readCompressedInt32();
        this.allocationGoal = reader.readCompressedInt64();
        if (history.isKeyGC()) {
            this.nrOfNonArrayClassesBeforeGc = reader.readCompressedInt64();
            this.nrOfNonArrayClassesAfterGc = reader.readCompressedInt64();
            this.nrOfArrayClassesBeforeGc = reader.readCompressedInt64();
            this.nrOfArrayClassesAfterGc = reader.readCompressedInt64();
        } else {
            this.nrOfNonArrayClassesBeforeGc = (long)reader.readCompressedInt32() * this.getSignFromBit(bools[3]) + history.getNrOfNonArrayClassesAfterLastGc();
            this.nrOfNonArrayClassesAfterGc = this.nrOfNonArrayClassesBeforeGc - (long)reader.readCompressedInt32() * this.getSignFromBit(bools[4]);
            this.nrOfArrayClassesBeforeGc = (long)reader.readCompressedInt32() * this.getSignFromBit(bools[5]) + history.getNrOfArrayClassesAfterLastGc();
            this.nrOfArrayClassesAfterGc = this.nrOfArrayClassesBeforeGc - (long)reader.readCompressedInt32() * this.getSignFromBit(bools[6]);
        }
        history.setNrOfNonArrayClassesAfterLastGc(this.nrOfNonArrayClassesAfterGc);
        history.setNrOfArrayClassesAfterLastGc(this.nrOfArrayClassesAfterGc);
        this.committedBytesInNonPermBeforeGc = reader.readInt64InvPercentage(history.getReservedJavaHeapSize(), this.exact);
        this.committedBytesInNonPermAfterGc = reader.readInt64InvPercentage(history.getReservedJavaHeapSize(), this.exact);
        this.bytesInNonPermBeforeGc = reader.readInt64Percentage(this.committedBytesInNonPermBeforeGc, this.exact);
        this.bytesInNonPermAfterGc = reader.readInt64Percentage(this.committedBytesInNonPermAfterGc, this.exact);
        this.committedBytesInYoungBeforeGc = reader.readInt64Percentage(history.getReservedJavaHeapSize(), this.exact);
        this.committedBytesInYoungAfterGc = reader.readInt64Percentage(history.getReservedJavaHeapSize(), this.exact);
        this.maxYoungGenSize = reader.readInt64Percentage(history.getReservedJavaHeapSize(), this.exact);
        this.committedBytesInEdenBeforeGc = reader.readInt64InvPercentage(this.maxYoungGenSize, this.exact);
        this.committedBytesInEdenAfterGc = reader.readInt64InvPercentage(this.maxYoungGenSize, this.exact);
        this.bytesInEdenBeforeGc = reader.readInt64InvPercentage(this.committedBytesInEdenBeforeGc, this.exact);
        this.bytesInEdenAfterGc = reader.readInt64Percentage(this.committedBytesInEdenAfterGc, this.exact);
        this.bytesWastedByTLABsBeforeGc = reader.readInt64Percentage(this.committedBytesInEdenBeforeGc, this.exact);
        this.committedBytesInFromBeforeGc = reader.readInt64Percentage(this.maxYoungGenSize, this.exact);
        this.committedBytesInFromAfterGc = reader.readInt64Percentage(this.maxYoungGenSize, this.exact);
        this.bytesInFromBeforeGc = reader.readInt64Percentage(this.committedBytesInFromBeforeGc, this.exact);
        this.bytesInFromAfterGc = reader.readInt64Percentage(this.committedBytesInFromAfterGc, this.exact);
        this.committedBytesInToBeforeGc = reader.readInt64Percentage(this.maxYoungGenSize, this.exact);
        this.committedBytesInToAfterGc = reader.readInt64Percentage(this.maxYoungGenSize, this.exact);
        this.bytesInToBeforeGc = reader.readInt64Percentage(this.committedBytesInToBeforeGc, this.exact);
        this.bytesInToAfterGc = reader.readInt64Percentage(this.committedBytesInToAfterGc, this.exact);
        this.committedBytesInOldBeforeGc = reader.readInt64InvPercentage(history.getReservedJavaHeapSize(), this.exact);
        this.committedBytesInOldAfterGc = reader.readInt64InvPercentage(history.getReservedJavaHeapSize(), this.exact);
        this.bytesInOldBeforeGc = reader.readInt64Percentage(this.committedBytesInOldBeforeGc, this.exact);
        this.bytesInOldAfterGc = reader.readInt64Percentage(this.committedBytesInOldAfterGc, this.exact);
        this.maxOldGenSize = reader.readInt64InvPercentage(history.getReservedJavaHeapSize(), this.exact);
        this.committedBytesInPermBeforeGc = reader.readInt64InvPercentage(history.getReservedPermGenSize(), this.exact);
        this.committedBytesInPermAfterGc = reader.readInt64InvPercentage(history.getReservedPermGenSize(), this.exact);
        this.bytesInPermBeforeGc = reader.readInt64Percentage(this.committedBytesInPermBeforeGc, this.exact);
        this.bytesInPermAfterGc = reader.readInt64Percentage(this.committedBytesInPermAfterGc, this.exact);
        this.maxPermGenSize = reader.readInt64InvPercentage(history.getReservedPermGenSize(), this.exact);
        this.tenuringThreshold = reader.readInt8();
        ByteArrayBasicResourceReader[] eventReaders = history.getGCEvents();
        this.gcEventTypes = history.getGCEventTypes();
        history.clearGCEvents();
        this.nrOfEvents = eventReaders.length;
        this.gcEvents = new GcEventBaseImpl[this.nrOfEvents];
        this.createEvents(eventReaders, this.gcEventTypes, mapInfo);
        if (history.isKeyGC()) {
            this.cumulativeDuration = reader.readInt64() * 1000L;
            this.cumulativeCpuTime = reader.readInt64() * 1000L;
            this.cumulativePageFaults = reader.readInt64();
            this.cumulativeMajorPageFaults = reader.readInt64();
            this.cumulativeMinorPageFaults = reader.readInt64();
            this.cumulativeNrOfUnloadedNonArrayClasses = reader.readInt64();
            this.cumulativeNrOfUnloadedArrayClasses = reader.readInt64();
            this.cumulativeBytesAllocatedInPerm = reader.readInt64();
            this.cumulativeBytesFreedInPerm = reader.readInt64();
            this.cumulativeBytesAllocatedInNonPerm = reader.readInt64();
            this.cumulativeBytesFreedInNonPerm = reader.readInt64();
            this.clearedSoftRefsSum = reader.readInt64();
            this.enqueuedSoftRefsSum = reader.readInt64();
            this.clearedWeakRefsSum = reader.readInt64();
            this.enqueuedWeakRefsSum = reader.readInt64();
            this.enqueuedFinalRefsSum = reader.readInt64();
            this.enqueuedPhantomRefsSum = reader.readInt64();
        } else {
            this.cumulativeDuration = history.getCumulativeDuration() + this.duration;
            this.cumulativeCpuTime = history.getCumulativeCpuTime() + this.cpuTime;
            this.cumulativePageFaults = history.getCumulativePageFaults() + this.pageFaults;
            this.cumulativeMajorPageFaults = history.getCumulativeMajorPageFaults() + this.majorPageFaults;
            this.cumulativeMinorPageFaults = history.getCumulativeMinorPageFaults() + this.minorPageFaults;
            this.cumulativeNrOfUnloadedNonArrayClasses = history.getCumulativeNrOfUnloadedNonArrayClasses() + this.nrOfNonArrayClassesBeforeGc - this.nrOfNonArrayClassesAfterGc;
            this.cumulativeNrOfUnloadedArrayClasses = history.getCumulativeNrOfUnloadedArrayClasses() + this.nrOfArrayClassesBeforeGc - this.nrOfArrayClassesAfterGc;
            this.cumulativeBytesAllocatedInPerm = history.getCumulativeBytesAllocatedInPerm() + this.bytesInPermBeforeGc - history.getBytesUsedInPermAfterGC();
            long freedBytes = this.bytesInPermBeforeGc - this.bytesInPermAfterGc;
            this.cumulativeBytesFreedInPerm = history.getCumulativeBytesFreedInPerm() + Math.max(freedBytes, 0L);
            this.cumulativeBytesAllocatedInNonPerm = history.getCumulativeBytesAllocatedInNonPerm() + this.bytesInNonPermBeforeGc - history.getBytesUsedInNonPermAfterGC();
            freedBytes = this.bytesInNonPermBeforeGc - this.bytesInNonPermAfterGc;
            if (this.allocationGoal > 0L && (double)this.allocationGoal * 1.1 > (double)this.bytesInEdenAfterGc && (double)this.allocationGoal * 0.9 < (double)this.bytesInEdenAfterGc) {
                freedBytes += this.allocationGoal;
            }
            this.cumulativeBytesFreedInNonPerm = history.getCumulativeBytesFreedInNonPerm() + Math.max(freedBytes, 0L);
            long cumulativeClearedSoftRefs = history.getClearedSoftRefsSum();
            long cumulativeEnqueuedSoftRefs = history.getEnqueuedSoftRefsSum();
            long cumulativeClearedWeakRefs = history.getClearedWeakRefsSum();
            long cumulativeEnqueuedWeakRefs = history.getEnqueuedWeakRefsSum();
            long cumulativeEnqueuedFinalRefs = history.getEnqueuedFinalRefsSum();
            long cumulativeEnqueuedPhantomRefs = history.getEnqueuedPhantomRefsSum();
            for (int i = 0; i < this.gcEvents.length; ++i) {
                if (!(this.gcEvents[i] instanceof GcEventReferenceHandling)) continue;
                GcEventReferenceHandling refEvent = (GcEventReferenceHandling)((Object)this.gcEvents[i]);
                cumulativeClearedSoftRefs += (long)refEvent.getSoftReferencesCleared();
                cumulativeEnqueuedSoftRefs += (long)refEvent.getSoftReferencesEnqueued();
                cumulativeClearedWeakRefs += (long)refEvent.getWeakReferencesCleared();
                cumulativeEnqueuedWeakRefs += (long)refEvent.getWeakReferencesEnqueued();
                cumulativeEnqueuedFinalRefs += (long)refEvent.getFinalReferencesEnqueued();
                cumulativeEnqueuedPhantomRefs += (long)refEvent.getPhantomReferencesEnqueued();
            }
            this.clearedSoftRefsSum = cumulativeClearedSoftRefs;
            this.enqueuedSoftRefsSum = cumulativeEnqueuedSoftRefs;
            this.clearedWeakRefsSum = cumulativeClearedWeakRefs;
            this.enqueuedWeakRefsSum = cumulativeEnqueuedWeakRefs;
            this.enqueuedFinalRefsSum = cumulativeEnqueuedFinalRefs;
            this.enqueuedPhantomRefsSum = cumulativeEnqueuedPhantomRefs;
        }
        history.setCumulativeDuration(this.cumulativeDuration);
        history.setCumulativeCpuTime(this.cumulativeCpuTime);
        history.setCumulativePageFaults(this.cumulativePageFaults);
        history.setCumulativeMajorPageFaults(this.cumulativeMajorPageFaults);
        history.setCumulativeMinorPageFaults(this.cumulativeMinorPageFaults);
        history.setCumulativeNrOfUnloadedNonArrayClasses(this.cumulativeNrOfUnloadedNonArrayClasses);
        history.setCumulativeNrOfUnloadedArrayClasses(this.cumulativeNrOfUnloadedArrayClasses);
        boolean enableAssertions = !(this instanceof GcStatisticConcMarkSweepGc) && !(this instanceof GcStatisticG1Gc) || this.ver() >= 1;
        history.enableCumulativeValueAssertions(enableAssertions);
        history.setCumulativeBytesAllocatedInPerm(this.cumulativeBytesAllocatedInPerm);
        history.setCumulativeBytesFreedInPerm(this.cumulativeBytesFreedInPerm);
        history.setCumulativeBytesAllocatedInNonPerm(this.cumulativeBytesAllocatedInNonPerm);
        history.setCumulativeBytesFreedInNonPerm(this.cumulativeBytesFreedInNonPerm);
        history.enableCumulativeValueAssertions(true);
        history.setClearedSoftRefsSum(this.clearedSoftRefsSum);
        history.setEnqueuedSoftRefsSum(this.enqueuedSoftRefsSum);
        history.setClearedWeakRefsSum(this.clearedWeakRefsSum);
        history.setEnqueuedWeakRefsSum(this.enqueuedWeakRefsSum);
        history.setEnqueuedFinalRefsSum(this.enqueuedFinalRefsSum);
        history.setEnqueuedPhantomRefsSum(this.enqueuedPhantomRefsSum);
        history.setBytesUsedInPermAfterGC(this.bytesInPermAfterGc);
        history.setBytesUsedInNonPermAfterGC(this.bytesInNonPermAfterGc);
        long lastConcGcEnd = mapInfo.getLastConcurrentGcEnd();
        this.millisSinceLastConcGC = lastConcGcEnd >= 0L ? Math.max(0L, this.timestamp - lastConcGcEnd) : -1L;
    }

    protected GcStatisticImpl(ResourceReader reader, MappingInformation mapInfo, GcType gcType, int dummy) throws IOException {
        assert (mapInfo.getSession().getSystemInfo().gcStatisticVersion() < 127);
        this.ver = (byte)mapInfo.getSession().getSystemInfo().gcStatisticVersion();
        this.gcType = gcType;
        this.cause = GcCause.get(reader.readInt8());
        this.fullGc = reader.readBoolean();
        this.forcedSoftRefClear = reader.readBoolean();
        this.gcNr = reader.readInt64();
        this.nrOfFullGcs = reader.readInt64();
        this.timestamp = reader.readInt64();
        this.duration = reader.readInt64();
        this.cpuTime = reader.readInt64();
        this.pageFaults = reader.readInt64();
        this.majorPageFaults = reader.readInt64();
        this.minorPageFaults = reader.readInt64();
        this.allocationGoal = reader.readInt64();
        this.nrOfNonArrayClassesBeforeGc = reader.readInt64();
        this.nrOfArrayClassesBeforeGc = reader.readInt64();
        this.nrOfNonArrayClassesAfterGc = reader.readInt64();
        this.nrOfArrayClassesAfterGc = reader.readInt64();
        this.bytesInNonPermBeforeGc = reader.readInt64();
        this.bytesInNonPermAfterGc = reader.readInt64();
        this.bytesInPermBeforeGc = reader.readInt64();
        this.bytesInPermAfterGc = reader.readInt64();
        this.committedBytesInNonPermBeforeGc = reader.readInt64();
        this.committedBytesInNonPermAfterGc = reader.readInt64();
        this.committedBytesInPermBeforeGc = reader.readInt64();
        this.committedBytesInPermAfterGc = reader.readInt64();
        this.maxPermGenSize = reader.readInt64();
        this.bytesInEdenBeforeGc = reader.readInt64();
        this.bytesInEdenAfterGc = reader.readInt64();
        this.committedBytesInEdenBeforeGc = reader.readInt64();
        this.committedBytesInEdenAfterGc = reader.readInt64();
        this.bytesWastedByTLABsBeforeGc = reader.readInt64();
        this.bytesInFromBeforeGc = reader.readInt64();
        this.bytesInFromAfterGc = reader.readInt64();
        this.committedBytesInFromBeforeGc = reader.readInt64();
        this.committedBytesInFromAfterGc = reader.readInt64();
        this.bytesInToBeforeGc = reader.readInt64();
        this.bytesInToAfterGc = reader.readInt64();
        this.committedBytesInToBeforeGc = reader.readInt64();
        this.committedBytesInToAfterGc = reader.readInt64();
        this.committedBytesInYoungBeforeGc = reader.readInt64();
        this.committedBytesInYoungAfterGc = reader.readInt64();
        this.maxYoungGenSize = reader.readInt64();
        this.bytesInOldBeforeGc = reader.readInt64();
        this.bytesInOldAfterGc = reader.readInt64();
        this.committedBytesInOldBeforeGc = reader.readInt64();
        this.committedBytesInOldAfterGc = reader.readInt64();
        this.maxOldGenSize = reader.readInt64();
        this.tenuringThreshold = reader.readInt32();
        this.cumulativeDuration = reader.readInt64();
        this.cumulativeCpuTime = reader.readInt64();
        this.cumulativePageFaults = reader.readInt64();
        this.cumulativeMajorPageFaults = reader.readInt64();
        this.cumulativeMinorPageFaults = reader.readInt64();
        this.cumulativeNrOfUnloadedNonArrayClasses = reader.readInt64();
        this.cumulativeNrOfUnloadedArrayClasses = reader.readInt64();
        this.cumulativeBytesAllocatedInPerm = reader.readInt64();
        this.cumulativeBytesFreedInPerm = reader.readInt64();
        this.cumulativeBytesAllocatedInNonPerm = reader.readInt64();
        this.cumulativeBytesFreedInNonPerm = reader.readInt64();
        this.clearedSoftRefsSum = reader.readInt64();
        this.enqueuedSoftRefsSum = reader.readInt64();
        this.clearedWeakRefsSum = reader.readInt64();
        this.enqueuedWeakRefsSum = reader.readInt64();
        this.enqueuedFinalRefsSum = reader.readInt64();
        this.enqueuedPhantomRefsSum = reader.readInt64();
        this.exact = reader.readBoolean();
        this.nrOfEvents = reader.readInt32();
        this.gcNrIsValid = true;
        this.gcEvents = new GcEventBaseImpl[this.nrOfEvents];
        this.gcEventTypes = new int[this.nrOfEvents];
        ByteArrayBasicResourceReader[] eventReaders = new ByteArrayBasicResourceReader[this.nrOfEvents];
        for (int i = 0; i < eventReaders.length; ++i) {
            this.gcEventTypes[i] = reader.readInt16();
            int length = reader.readInt32();
            byte[] data = new byte[length];
            reader.readBytes(data);
            eventReaders[i] = new ByteArrayBasicResourceReader(data);
        }
        this.createEvents(eventReaders, this.gcEventTypes, mapInfo);
        long lastConcGcEnd = mapInfo.getLastConcurrentGcEnd();
        this.millisSinceLastConcGC = lastConcGcEnd >= 0L ? Math.max(0L, this.timestamp - lastConcGcEnd) : -1L;
    }

    private void createEvents(ByteArrayBasicResourceReader[] readers, int[] types, MappingInformation mapInfo) throws IOException {
        assert (readers.length == this.nrOfEvents);
        block45: for (int i = 0; i < this.nrOfEvents; ++i) {
            int gcEventType = types[i];
            switch (gcEventType) {
                case 566: {
                    this.gcEvents[i] = new GcEventParallelGcScavengeImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 567: {
                    this.gcEvents[i] = new GcEventSkippedParallelGcScavengeImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 568: {
                    this.gcEvents[i] = new GcEventParallelGcMarkSweepImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 569: {
                    this.gcEvents[i] = new GcEventSkippedParallelGcMarkSweepImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 570: {
                    this.gcEvents[i] = new GcEventParallelGcParallelCompactImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 571: {
                    this.gcEvents[i] = new GcEventParallelSmallGcForcedFullGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 572: {
                    this.gcEvents[i] = new GcEventSkippedParallelGcParallelCompactImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 573: {
                    this.gcEvents[i] = new GcEventSerialNewGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 574: {
                    this.gcEvents[i] = new GcEventSkippedSerialNewGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 575: {
                    this.gcEvents[i] = new GcEventParallelNewGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 576: {
                    this.gcEvents[i] = new GcEventSkippedParallelNewGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 577: {
                    this.gcEvents[i] = new GcEventTenuredGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 578: {
                    this.gcEvents[i] = new GcEventSkippedTenuredGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 579: {
                    this.gcEvents[i] = new GcEventYoungGenRefHandlingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 580: {
                    this.gcEvents[i] = new GcEventAllGenRefHandlingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 581: {
                    this.gcEvents[i] = new GcEventOldGenRefHandlingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 582: {
                    this.gcEvents[i] = new GcEventCmsInitialMarkingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 583: {
                    this.gcEvents[i] = new GcEventCmsMarkingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 584: {
                    this.gcEvents[i] = new GcEventCmsPrecleaningImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 585: {
                    this.gcEvents[i] = new GcEventCmsAbortablePrecleaningImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 586: {
                    this.gcEvents[i] = new GcEventCmsFinalMarkingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 587: {
                    this.gcEvents[i] = new GcEventCmsSweepingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 588: {
                    this.gcEvents[i] = new GcEventCmsAbortedImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 589: {
                    this.gcEvents[i] = new GcEventYoungGenPromotionFailureImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 700: {
                    this.gcEvents[i] = new GcEventG1IncrementalGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 701: {
                    this.gcEvents[i] = new GcEventSkippedG1IncrementalGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 702: {
                    this.gcEvents[i] = new GcEventG1MarkSweepGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 703: {
                    this.gcEvents[i] = new GcEventSkippedG1MarkSweepGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 706: {
                    this.gcEvents[i] = new GcEventG1InitialMarkingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 707: {
                    this.gcEvents[i] = new GcEventG1MarkingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 708: {
                    this.gcEvents[i] = new GcEventG1FinalMarkingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 709: {
                    this.gcEvents[i] = new GcEventG1CountingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 710: {
                    this.gcEvents[i] = new GcEventG1CleanupImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 711: {
                    this.gcEvents[i] = new GcEventG1ConcurrentCleanupImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 712: {
                    this.gcEvents[i] = new GcEventG1BitmapClearingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 713: {
                    this.gcEvents[i] = new GcEventG1MarkingAbortedImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 754: {
                    this.gcEvents[i] = new GcEventG1RootScanningImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 755: {
                    this.gcEvents[i] = new GcEventPartialRefHandlingImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 786: {
                    this.gcEvents[i] = new GcEventClassunloadingPhase1Impl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 787: {
                    this.gcEvents[i] = new GcEventClassunloadingPhase2Impl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 788: {
                    this.gcEvents[i] = new GcEventG1ParallelFullGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 789: {
                    this.gcEvents[i] = new GcEventSkippedG1ParallelFullGcImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                case 930: {
                    this.gcEvents[i] = new GcEventG1EmptyRegionsReclaimImpl(readers[i], mapInfo, this);
                    continue block45;
                }
                default: {
                    assert (false);
                    continue block45;
                }
            }
        }
    }

    private long getSignFromBit(boolean isNegative) {
        return isNegative ? -1L : 1L;
    }

    protected void addCumulativeNrOfUnloadedNonArrayClasses(long value) {
        this.cumulativeNrOfUnloadedNonArrayClasses += value;
    }

    protected void addCumulativeNrOfUnloadedArrayClasses(long value) {
        this.cumulativeNrOfUnloadedArrayClasses += value;
    }

    protected void addCumulativeBytesAllocatedInPerm(long allocated) {
        this.cumulativeBytesAllocatedInPerm += allocated;
    }

    protected void addCumulativeBytesFreedInPerm(long freed) {
        this.cumulativeBytesFreedInPerm += freed;
    }

    protected void addCumulativeBytesAllocatedInNonPerm(long allocated) {
        this.cumulativeBytesAllocatedInNonPerm += allocated;
    }

    protected void addCumulativeBytesFreedInNonPerm(long freed) {
        this.cumulativeBytesFreedInNonPerm += freed;
    }

    @Override
    public GcCause getCause() {
        return this.cause;
    }

    @Override
    public boolean isForcedSoftRefClear() {
        return this.forcedSoftRefClear;
    }

    @Override
    public GcType getGcType() {
        return this.gcType;
    }

    @Override
    public long getNrOfArrayClassesAfterGc() {
        return this.nrOfArrayClassesAfterGc;
    }

    @Override
    public long getNrOfArrayClassesBeforeGc() {
        return this.nrOfArrayClassesBeforeGc;
    }

    @Override
    public long getNrOfNonArrayClassesAfterGc() {
        return this.nrOfNonArrayClassesAfterGc;
    }

    @Override
    public long getNrOfNonArrayClassesBeforeGc() {
        return this.nrOfNonArrayClassesBeforeGc;
    }

    @Override
    public long getAllocationGoal() {
        return this.allocationGoal;
    }

    @Override
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public boolean isFullGc() {
        return this.fullGc;
    }

    @Override
    public long getGcNr() {
        return this.gcNr;
    }

    @Override
    public long getPageFaults() {
        return this.pageFaults;
    }

    @Override
    public long getMajorPageFaults() {
        return this.majorPageFaults;
    }

    @Override
    public long getMinorPageFaults() {
        return this.minorPageFaults;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    private void printSpace(ProfilingPrintStream stream, String heapName, String maxHeapName, long usedBefore, long usedAfter, long committedBefore, long committedAfter, long max) {
        stream.formatln("%-40s: %*B, %.2f%% of committed, %.2f%% of %s", "Used in " + heapName + " before GC", usedBefore, 100.0 * (double)usedBefore / (double)committedBefore, 100.0 * (double)usedBefore / (double)max, maxHeapName);
        stream.formatln("%-40s: %*B, %.2f%% of committed, %.2f%% of %s", "Used in " + heapName + " after GC", usedAfter, 100.0 * (double)usedAfter / (double)committedAfter, 100.0 * (double)usedAfter / (double)max, maxHeapName);
        long freed = usedBefore - usedAfter;
        stream.formatln("%-40s: %*B, %.2f%% of %s", "Bytes freed in " + heapName, freed, 100.0 * (double)freed / (double)max, maxHeapName);
        stream.formatln("%-40s: %*B, %.2f%% of %s", "Committed in " + heapName + " before GC", committedBefore, 100.0 * (double)committedBefore / (double)max, maxHeapName);
        stream.formatln("%-40s: %*B, %.2f%% of %s", "Committed in " + heapName + " after GC", committedAfter, 100.0 * (double)committedAfter / (double)max, maxHeapName);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        if (GcStatisticTraceLevel.getCurrentLevel() == GcStatisticTraceLevel.SHORT) {
            stream.formatln("[GC: type=%s|duration=%.2f ms|cpu time=%.2f ms|heap before=%s|heap after=%s|perm before=%s|perm after=%s]", this.fullGc ? "full" : "partial", (double)this.duration / 1000.0, (double)this.cpuTime / 1000.0, DataFormatter.getNrOfBytesText(this.bytesInNonPermBeforeGc), DataFormatter.getNrOfBytesText(this.bytesInNonPermAfterGc), DataFormatter.getNrOfBytesText(this.bytesInPermBeforeGc), DataFormatter.getNrOfBytesText(this.bytesInPermAfterGc));
        } else {
            stream.println("GC Statistic:");
            stream.println("GC Nr.                                  : " + this.gcNr);
            stream.println("GC started                              : " + new Date(this.timestamp));
            stream.println("Nr. of full GCs                         : " + this.nrOfFullGcs);
            stream.println("GC algorithm                            : " + this.gcType.getDescription());
            stream.println("Reason                                  : " + this.cause.getDescription());
            stream.println("Type                                    : " + (this.fullGc ? "full" : "partial"));
            stream.println("Forced clearing of SoftRefs             : " + (this.forcedSoftRefClear ? "yes" : "no"));
            stream.formatln("Duration                                : %.2f ms", (double)this.duration / 1000.0);
            stream.formatln("Cumulative duration                     : %.2f ms", (double)this.cumulativeDuration / 1000.0);
            stream.formatln("CPU time                                : %.2f ms", (double)this.cpuTime / 1000.0);
            stream.formatln("Cumulative CPU time                     : %.2f ms", (double)this.cumulativeCpuTime / 1000.0);
            stream.println("Page faults                             : " + this.pageFaults);
            stream.println("Cumulative Page faults                  : " + this.cumulativePageFaults);
            stream.println("Major page faults                       : " + this.majorPageFaults);
            stream.println("Cumulative Major page faults            : " + this.cumulativeMajorPageFaults);
            stream.println("Minor page faults                       : " + this.minorPageFaults);
            stream.println("Cumulative Minor page faults            : " + this.cumulativeMinorPageFaults);
            if (this.allocationGoal > 0L) {
                stream.formatln("Allocation goal                         : %*B", this.allocationGoal);
            } else {
                stream.println("Allocation goal                         : none");
            }
            this.printSpace(stream, "Java heap", "Java heap max (max young + max old)", this.bytesInNonPermBeforeGc, this.bytesInNonPermAfterGc, this.committedBytesInNonPermBeforeGc, this.committedBytesInNonPermAfterGc, this.maxYoungGenSize + this.maxOldGenSize);
            long freedCommittedNonPerm = this.committedBytesInNonPermBeforeGc - this.committedBytesInNonPermAfterGc;
            stream.formatln("Bytes decommitted in Java heap          : %*B", freedCommittedNonPerm);
            if (GcStatisticTraceLevel.getCurrentLevel() != GcStatisticTraceLevel.FULL) {
                this.printSpace(stream, "perm gen", "perm gen max", this.bytesInPermBeforeGc, this.bytesInPermAfterGc, this.committedBytesInPermBeforeGc, this.committedBytesInPermAfterGc, this.maxPermGenSize);
            }
            long unloadedClasses = this.nrOfNonArrayClassesBeforeGc + this.nrOfArrayClassesBeforeGc - (this.nrOfNonArrayClassesAfterGc + this.nrOfArrayClassesAfterGc);
            stream.println("Nr. of unloaded classes                 : " + unloadedClasses);
            if (GcStatisticTraceLevel.getCurrentLevel() == GcStatisticTraceLevel.FULL) {
                stream.println("Nr. of non array classes before GC      : " + this.nrOfNonArrayClassesBeforeGc);
                stream.println("Nr. of non array classes after GC       : " + this.nrOfNonArrayClassesAfterGc);
                stream.println("Nr. of array classes before GC          : " + this.nrOfArrayClassesBeforeGc);
                stream.println("Nr. of array classes after GC           : " + this.nrOfArrayClassesAfterGc);
                stream.println("Cumulative unloaded non-array classes   : " + this.cumulativeNrOfUnloadedNonArrayClasses);
                stream.println("Cumulative unloaded array classes       : " + this.cumulativeNrOfUnloadedArrayClasses);
                this.printSpace(stream, "eden", "young gen max", this.bytesInEdenBeforeGc, this.bytesInEdenAfterGc, this.committedBytesInEdenBeforeGc, this.committedBytesInEdenAfterGc, this.maxYoungGenSize);
                stream.formatln("TLAB waste in eden space before GC      : %*B, %.2f%% of used in eden", this.bytesWastedByTLABsBeforeGc, 100.0 * (double)this.bytesWastedByTLABsBeforeGc / (double)this.bytesInEdenBeforeGc);
                this.printSpace(stream, "'from' space", "young gen max", this.bytesInFromBeforeGc, this.bytesInFromAfterGc, this.committedBytesInFromBeforeGc, this.committedBytesInFromAfterGc, this.maxYoungGenSize);
                this.printSpace(stream, "'to' space", "young gen max", this.bytesInToBeforeGc, this.bytesInToAfterGc, this.committedBytesInToBeforeGc, this.committedBytesInToAfterGc, this.maxYoungGenSize);
                stream.formatln("Max in young gen                        : %*B", this.maxYoungGenSize);
                this.printSpace(stream, "young gen", "young gen max", this.bytesInToBeforeGc + this.bytesInFromBeforeGc + this.bytesInEdenBeforeGc, this.bytesInToAfterGc + this.bytesInFromAfterGc + this.bytesInEdenAfterGc, this.committedBytesInYoungBeforeGc, this.committedBytesInYoungAfterGc, this.maxYoungGenSize);
                stream.println("Tenuring threshold                      : " + this.tenuringThreshold);
                stream.formatln("Max in old gen                          : %*B", this.maxOldGenSize);
                this.printSpace(stream, "old gen", "old gen max", this.bytesInOldBeforeGc, this.bytesInOldAfterGc, this.committedBytesInOldBeforeGc, this.committedBytesInOldAfterGc, this.maxOldGenSize);
                stream.formatln("Max in perm gen                         : %*B", this.maxPermGenSize);
                this.printSpace(stream, "perm gen", "perm gen max", this.bytesInPermBeforeGc, this.bytesInPermAfterGc, this.committedBytesInPermBeforeGc, this.committedBytesInPermAfterGc, this.maxPermGenSize);
                if (this.maxClassSpaceSize > 0L) {
                    stream.formatln("Max in class metaspace                  : %*B", this.maxClassSpaceSize);
                    this.printSpace(stream, "class space", "class space max", this.bytesInClassSpaceBeforeGc, this.bytesInClassSpaceAfterGc, this.committedBytesInClassSpaceBeforeGc, this.committedBytesInClassSpaceAfterGc, this.maxClassSpaceSize);
                }
                stream.formatln("Bytes allocated in non-perm until now   : %*B", this.cumulativeBytesAllocatedInNonPerm);
                stream.formatln("Bytes freed in non-perm until now       : %*B", this.cumulativeBytesFreedInNonPerm);
                stream.formatln("Bytes allocated in perm until now       : %*B", this.cumulativeBytesAllocatedInPerm);
                stream.formatln("Bytes freed in perm until now           : %*B", this.cumulativeBytesFreedInPerm);
                stream.println("Nr. of soft refs cleared until now      : " + this.clearedSoftRefsSum);
                stream.println("Nr. of soft refs enqueued until now     : " + this.enqueuedSoftRefsSum);
                stream.println("Nr. of weak refs cleared until now      : " + this.clearedWeakRefsSum);
                stream.println("Nr. of weak refs enqueued until now     : " + this.enqueuedWeakRefsSum);
                stream.println("Nr. of final refs enqueued until now    : " + this.enqueuedFinalRefsSum);
                stream.println("Nr. of phantom refs enqueued until now  : " + this.enqueuedPhantomRefsSum);
            }
        }
    }

    protected void printEvents(ProfilingPrintStream stream) {
        int level = GcStatisticTraceLevel.getCurrentLevel().getLevel();
        if (level != GcStatisticTraceLevel.SHORT.getLevel()) {
            stream.println();
            if (level > GcStatisticTraceLevel.MEDIUM.getLevel()) {
                stream.println("Nr. of GC events                        : " + this.nrOfEvents);
                stream.println();
                for (int i = 0; i < this.nrOfEvents; ++i) {
                    stream.println("GC event nr.                            : " + (i + 1));
                    this.gcEvents[i].print(stream);
                    stream.println();
                }
            }
        }
    }

    @Override
    public long getBytesInEdenAfterGc() {
        return this.bytesInEdenAfterGc;
    }

    @Override
    public long getBytesInEdenBeforeGc() {
        return this.bytesInEdenBeforeGc;
    }

    @Override
    public long getBytesInFromAfterGc() {
        return this.bytesInFromAfterGc;
    }

    @Override
    public long getBytesInFromBeforeGc() {
        return this.bytesInFromBeforeGc;
    }

    @Override
    public long getBytesInOldAfterGc() {
        return this.bytesInOldAfterGc;
    }

    @Override
    public long getBytesInOldBeforeGc() {
        return this.bytesInOldBeforeGc;
    }

    @Override
    public long getBytesInToAfterGc() {
        return this.bytesInToAfterGc;
    }

    @Override
    public long getBytesInToBeforeGc() {
        return this.bytesInToBeforeGc;
    }

    @Override
    public long getBytesInNonPermAfterGc() {
        return this.bytesInNonPermAfterGc;
    }

    @Override
    public long getBytesInNonPermBeforeGc() {
        return this.bytesInNonPermBeforeGc;
    }

    @Override
    public long getBytesInPermAfterGc() {
        return this.bytesInPermAfterGc;
    }

    @Override
    public long getBytesInPermBeforeGc() {
        return this.bytesInPermBeforeGc;
    }

    @Override
    public long getBytesInClassSpaceAfterGc() {
        return this.bytesInClassSpaceAfterGc;
    }

    @Override
    public long getBytesInClassSpaceBeforeGc() {
        return this.bytesInClassSpaceBeforeGc;
    }

    @Override
    public long getBytesInYoungAfterGc() {
        return this.bytesInEdenAfterGc + this.bytesInToAfterGc + this.bytesInFromAfterGc;
    }

    @Override
    public long getBytesInYoungBeforeGc() {
        return this.bytesInEdenBeforeGc + this.bytesInToBeforeGc + this.bytesInFromBeforeGc;
    }

    @Override
    public long getCommittedBytesInEdenAfterGc() {
        return this.committedBytesInEdenAfterGc;
    }

    @Override
    public long getCommittedBytesInEdenBeforeGc() {
        return this.committedBytesInEdenBeforeGc;
    }

    @Override
    public long getBytesWastedByTLABsBeforeGc() {
        return this.bytesWastedByTLABsBeforeGc;
    }

    @Override
    public long getCommittedBytesInFromAfterGc() {
        return this.committedBytesInFromAfterGc;
    }

    @Override
    public long getCommittedBytesInFromBeforeGc() {
        return this.committedBytesInFromBeforeGc;
    }

    @Override
    public long getCommittedBytesInOldAfterGc() {
        return this.committedBytesInOldAfterGc;
    }

    @Override
    public long getCommittedBytesInOldBeforeGc() {
        return this.committedBytesInOldBeforeGc;
    }

    @Override
    public long getCommittedBytesInToAfterGc() {
        return this.committedBytesInToAfterGc;
    }

    @Override
    public long getCommittedBytesInToBeforeGc() {
        return this.committedBytesInToBeforeGc;
    }

    @Override
    public long getCommittedBytesInYoungAfterGc() {
        return this.committedBytesInYoungAfterGc;
    }

    @Override
    public long getCommittedBytesInYoungBeforeGc() {
        return this.committedBytesInYoungBeforeGc;
    }

    @Override
    public long getCommittedBytesInNonPermAfterGc() {
        return this.committedBytesInNonPermAfterGc;
    }

    @Override
    public long getCommittedBytesInNonPermBeforeGc() {
        return this.committedBytesInNonPermBeforeGc;
    }

    @Override
    public long getCommittedBytesInPermAfterGc() {
        return this.committedBytesInPermAfterGc;
    }

    @Override
    public long getCommittedBytesInPermBeforeGc() {
        return this.committedBytesInPermBeforeGc;
    }

    @Override
    public long getCommittedBytesInClassSpaceAfterGc() {
        return this.committedBytesInClassSpaceAfterGc;
    }

    @Override
    public long getCommittedBytesInClassSpaceBeforeGc() {
        return this.committedBytesInClassSpaceBeforeGc;
    }

    @Override
    public long getMaxOldGenSize() {
        return this.maxOldGenSize;
    }

    @Override
    public long getMaxPermGenSize() {
        return this.maxPermGenSize;
    }

    @Override
    public long getMaxClassSpaceSize() {
        return this.maxClassSpaceSize;
    }

    @Override
    public long getMaxNonPermGenSize() {
        return this.maxOldGenSize + this.maxYoungGenSize;
    }

    @Override
    public long getMaxYoungGenSize() {
        return this.maxYoungGenSize;
    }

    @Override
    public int getNrOfEvents() {
        return this.nrOfEvents;
    }

    @Override
    public GcEventBase[] getEvents() {
        return this.gcEvents;
    }

    @Override
    public long getNrOfFullGcs() {
        return this.nrOfFullGcs;
    }

    @Override
    public int getTenuringThreshold() {
        return this.tenuringThreshold;
    }

    @Override
    public long getCumulativeDuration() {
        return this.cumulativeDuration;
    }

    @Override
    public long getCumulativeCpuTime() {
        return this.cumulativeCpuTime;
    }

    @Override
    public long getCumulativePageFaults() {
        return this.cumulativePageFaults;
    }

    @Override
    public long getCumulativeMajorPageFaults() {
        return this.cumulativeMajorPageFaults;
    }

    @Override
    public long getCumulativeMinorPageFaults() {
        return this.cumulativeMinorPageFaults;
    }

    @Override
    public long getCumulativeNrOfUnloadedNonArrayClasses() {
        return this.cumulativeNrOfUnloadedNonArrayClasses;
    }

    @Override
    public long getCumulativeNrOfUnloadedArrayClasses() {
        return this.cumulativeNrOfUnloadedArrayClasses;
    }

    @Override
    public long getCumulativeBytesAllocatedInPerm() {
        return this.cumulativeBytesAllocatedInPerm;
    }

    @Override
    public long getCumulativeBytesFreedInPerm() {
        return this.cumulativeBytesFreedInPerm;
    }

    @Override
    public long getCumulativeBytesAllocatedInNonPerm() {
        return this.cumulativeBytesAllocatedInNonPerm;
    }

    @Override
    public long getCumulativeBytesFreedInNonPerm() {
        return this.cumulativeBytesFreedInNonPerm;
    }

    @Override
    public long getClearedSoftRefsSum() {
        return this.clearedSoftRefsSum;
    }

    @Override
    public long getEnqueuedSoftRefsSum() {
        return this.enqueuedSoftRefsSum;
    }

    @Override
    public long getClearedWeakRefsSum() {
        return this.clearedWeakRefsSum;
    }

    @Override
    public long getEnqueuedWeakRefsSum() {
        return this.enqueuedWeakRefsSum;
    }

    @Override
    public long getEnqueuedFinalRefsSum() {
        return this.enqueuedFinalRefsSum;
    }

    @Override
    public long getEnqueuedPhantomRefsSum() {
        return this.enqueuedPhantomRefsSum;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.writeInt8(GcCause.get(this.cause));
        writer.writeBoolean(this.fullGc);
        writer.writeBoolean(this.forcedSoftRefClear);
        writer.writeInt64(this.gcNr);
        writer.writeInt64(this.nrOfFullGcs);
        writer.writeInt64(this.timestamp);
        writer.writeInt64(this.duration);
        writer.writeInt64(this.cpuTime);
        writer.writeInt64(this.pageFaults);
        writer.writeInt64(this.majorPageFaults);
        writer.writeInt64(this.minorPageFaults);
        writer.writeInt64(this.allocationGoal);
        writer.writeInt64(this.nrOfNonArrayClassesBeforeGc);
        writer.writeInt64(this.nrOfArrayClassesBeforeGc);
        writer.writeInt64(this.nrOfNonArrayClassesAfterGc);
        writer.writeInt64(this.nrOfArrayClassesAfterGc);
        writer.writeInt64(this.bytesInNonPermBeforeGc);
        writer.writeInt64(this.bytesInNonPermAfterGc);
        writer.writeInt64(this.bytesInPermBeforeGc);
        writer.writeInt64(this.bytesInPermAfterGc);
        writer.writeInt64(this.committedBytesInNonPermBeforeGc);
        writer.writeInt64(this.committedBytesInNonPermAfterGc);
        writer.writeInt64(this.committedBytesInPermBeforeGc);
        writer.writeInt64(this.committedBytesInPermAfterGc);
        writer.writeInt64(this.maxPermGenSize);
        writer.writeInt64(this.bytesInEdenBeforeGc);
        writer.writeInt64(this.bytesInEdenAfterGc);
        writer.writeInt64(this.committedBytesInEdenBeforeGc);
        writer.writeInt64(this.committedBytesInEdenAfterGc);
        writer.writeInt64(this.bytesWastedByTLABsBeforeGc);
        writer.writeInt64(this.bytesInFromBeforeGc);
        writer.writeInt64(this.bytesInFromAfterGc);
        writer.writeInt64(this.committedBytesInFromBeforeGc);
        writer.writeInt64(this.committedBytesInFromAfterGc);
        writer.writeInt64(this.bytesInToBeforeGc);
        writer.writeInt64(this.bytesInToAfterGc);
        writer.writeInt64(this.committedBytesInToBeforeGc);
        writer.writeInt64(this.committedBytesInToAfterGc);
        writer.writeInt64(this.committedBytesInYoungBeforeGc);
        writer.writeInt64(this.committedBytesInYoungAfterGc);
        writer.writeInt64(this.maxYoungGenSize);
        writer.writeInt64(this.bytesInOldBeforeGc);
        writer.writeInt64(this.bytesInOldAfterGc);
        writer.writeInt64(this.committedBytesInOldBeforeGc);
        writer.writeInt64(this.committedBytesInOldAfterGc);
        writer.writeInt64(this.maxOldGenSize);
        writer.writeInt32(this.tenuringThreshold);
        writer.writeInt64(this.cumulativeDuration);
        writer.writeInt64(this.cumulativeCpuTime);
        writer.writeInt64(this.cumulativePageFaults);
        writer.writeInt64(this.cumulativeMajorPageFaults);
        writer.writeInt64(this.cumulativeMinorPageFaults);
        writer.writeInt64(this.cumulativeNrOfUnloadedNonArrayClasses);
        writer.writeInt64(this.cumulativeNrOfUnloadedArrayClasses);
        writer.writeInt64(this.cumulativeBytesAllocatedInPerm);
        writer.writeInt64(this.cumulativeBytesFreedInPerm);
        writer.writeInt64(this.cumulativeBytesAllocatedInNonPerm);
        writer.writeInt64(this.cumulativeBytesFreedInNonPerm);
        writer.writeInt64(this.clearedSoftRefsSum);
        writer.writeInt64(this.enqueuedSoftRefsSum);
        writer.writeInt64(this.clearedWeakRefsSum);
        writer.writeInt64(this.enqueuedWeakRefsSum);
        writer.writeInt64(this.enqueuedFinalRefsSum);
        writer.writeInt64(this.enqueuedPhantomRefsSum);
        writer.writeBoolean(this.exact);
        writer.writeInt32(this.nrOfEvents);
        for (int i = 0; i < this.nrOfEvents; ++i) {
            writer.writeInt16((short)this.gcEventTypes[i]);
            this.gcEvents[i].writeInternal(writer);
        }
    }

    protected void writeClassSpace(PacketResourceWriter writer) throws IOException {
        writer.writeInt64(this.committedBytesInClassSpaceBeforeGc);
        writer.writeInt64(this.committedBytesInClassSpaceAfterGc);
        writer.writeInt64(this.bytesInClassSpaceBeforeGc);
        writer.writeInt64(this.bytesInClassSpaceAfterGc);
        writer.writeInt64(this.maxClassSpaceSize);
    }

    protected void readClassSpace(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        if (history.getMaxClassSpaceSize() > 0L) {
            this.committedBytesInClassSpaceBeforeGc = reader.hasNext() ? reader.readInt64InvPercentage(history.getMaxClassSpaceSize(), this.exact) : 0L;
            this.committedBytesInClassSpaceAfterGc = reader.hasNext() ? reader.readInt64InvPercentage(history.getMaxClassSpaceSize(), this.exact) : 0L;
            this.bytesInClassSpaceBeforeGc = reader.hasNext() ? reader.readInt64Percentage(this.committedBytesInClassSpaceBeforeGc, this.exact) : 0L;
            this.bytesInClassSpaceAfterGc = reader.hasNext() ? reader.readInt64Percentage(this.committedBytesInClassSpaceAfterGc, this.exact) : 0L;
            this.maxClassSpaceSize = reader.hasNext() ? reader.readInt64InvPercentage(history.getMaxClassSpaceSize(), this.exact) : 0L;
        } else {
            this.maxClassSpaceSize = this.maxPermGenSize;
        }
    }

    protected void readClassSpace(ResourceReader reader, MappingInformation mapInfo, int dummy) throws IOException {
        this.committedBytesInClassSpaceBeforeGc = reader.hasNext(8) ? reader.readInt64() : 0L;
        this.committedBytesInClassSpaceAfterGc = reader.hasNext(8) ? reader.readInt64() : 0L;
        this.bytesInClassSpaceBeforeGc = reader.hasNext(8) ? reader.readInt64() : 0L;
        this.bytesInClassSpaceAfterGc = reader.hasNext(8) ? reader.readInt64() : 0L;
        this.maxClassSpaceSize = reader.hasNext(8) ? reader.readInt64() : this.maxPermGenSize;
    }

    public final boolean isExact() {
        return this.exact;
    }

    @Override
    public long getMaxStopTheWorldDuration() {
        return this.duration;
    }

    @Override
    public long getMillisSinceLastConcGC() {
        return this.millisSinceLastConcGC;
    }

    @Override
    public long getLastEventEndTimeStamp() {
        GcEventBase[] events = this.getEvents();
        if (events.length == 0) {
            return this.getTimestamp();
        }
        GcEventBase lastEvent = events[events.length - 1];
        long timeStamp = lastEvent.getTimestamp();
        if (lastEvent instanceof GcDurationEventBase) {
            timeStamp += ((GcDurationEventBase)lastEvent).getDuration() / 1000L;
        }
        return timeStamp;
    }

    public boolean gcNrValid() {
        return this.gcNrIsValid;
    }

    public static boolean skipGcStatistic(GcStatisticImpl gcStatistic) {
        return !gcStatistic.gcNrIsValid;
    }

    public int ver() {
        return this.ver;
    }
}

