/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelNewGc;
import com.sap.jvm.profiling.memory.event.GcStatisticTraceLevel;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class GcStatisticParallelNewGcImpl
extends GcStatisticImpl
implements GcStatisticParallelNewGc {
    private final int nrOfScavengeThreads;

    public GcStatisticParallelNewGcImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        super(reader, mapInfo, GcType.PARALLEL_NEW_GC);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        this.nrOfScavengeThreads = history.getNumberOfGCThreads();
        this.readClassSpace(reader, mapInfo);
    }

    public GcStatisticParallelNewGcImpl(ResourceReader reader, MappingInformation mapInfo, int dummy) throws IOException {
        super(reader, mapInfo, GcType.PARALLEL_NEW_GC, dummy);
        this.nrOfScavengeThreads = reader.readInt32();
        this.readClassSpace(reader, mapInfo, dummy);
    }

    public static GcStatisticParallelNewGcImpl read(ResourceReader reader, GcEventHandler[] handlers, MappingInformation mapInfo, boolean withEvents) throws IOException {
        GcStatisticParallelNewGcImpl result;
        if (withEvents) {
            result = new GcStatisticParallelNewGcImpl(reader, mapInfo, 0);
        } else {
            result = new GcStatisticParallelNewGcImpl(reader, mapInfo);
            if (GcStatisticParallelNewGcImpl.skipGcStatistic(result)) {
                return null;
            }
        }
        for (GcEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        if (GcStatisticTraceLevel.getCurrentLevel() == GcStatisticTraceLevel.FULL) {
            stream.println("Number of parallel new GC threads       : " + this.nrOfScavengeThreads);
        }
        this.printEvents(stream);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)694);
        super.write(writer);
        writer.writeInt32(this.nrOfScavengeThreads);
        this.writeClassSpace(writer);
        writer.finalizePacket();
    }

    @Override
    public int getNrOfScavengeThreads() {
        return this.nrOfScavengeThreads;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.GC_STATISTIC_PARALLEL_NEW_GC_EVENT;
    }

    @Override
    public String getPacketName() {
        return "ParNew GC event";
    }
}

