/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelOldGc;
import com.sap.jvm.profiling.memory.event.GcStatisticTraceLevel;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class GcStatisticParallelOldGcImpl
extends GcStatisticImpl
implements GcStatisticParallelOldGc {
    private final int nrOfScavengeThreads;
    private final int nrOfCompactThreads;

    public GcStatisticParallelOldGcImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        super(reader, mapInfo, GcType.PARALLEL_OLD_GC);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        this.nrOfScavengeThreads = history.getNumberOfGCThreads();
        this.nrOfCompactThreads = history.getNumberOfGCThreads();
        this.readClassSpace(reader, mapInfo);
    }

    public GcStatisticParallelOldGcImpl(ResourceReader reader, MappingInformation mapInfo, int dummy) throws IOException {
        super(reader, mapInfo, GcType.PARALLEL_OLD_GC, dummy);
        this.nrOfScavengeThreads = reader.readInt32();
        this.nrOfCompactThreads = reader.readInt32();
        this.readClassSpace(reader, mapInfo, dummy);
    }

    public static GcStatisticParallelOldGcImpl read(ResourceReader reader, GcEventHandler[] handlers, MappingInformation mapInfo, boolean withEvents) throws IOException {
        GcStatisticParallelOldGcImpl result = withEvents ? new GcStatisticParallelOldGcImpl(reader, mapInfo, 0) : new GcStatisticParallelOldGcImpl(reader, mapInfo);
        for (GcEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        if (GcStatisticTraceLevel.getCurrentLevel() == GcStatisticTraceLevel.FULL) {
            stream.println("Number of parallel scavenge threads     : " + this.nrOfScavengeThreads);
            stream.println("Number of parallel compact threads      : " + this.nrOfCompactThreads);
        }
        this.printEvents(stream);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)695);
        super.write(writer);
        writer.writeInt32(this.nrOfScavengeThreads);
        writer.writeInt32(this.nrOfCompactThreads);
        this.writeClassSpace(writer);
        writer.finalizePacket();
    }

    @Override
    public int getNrOfScavengeThreads() {
        return this.nrOfScavengeThreads;
    }

    @Override
    public int getNrOfCompactThreads() {
        return this.nrOfCompactThreads;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.GC_STATISTIC_PARALLEL_OLD_GC_EVENT;
    }

    @Override
    public String getPacketName() {
        return "Parallel Old GC event";
    }
}

