/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.memory.event.HprofDumpEnd;
import com.sap.jvm.profiling.memory.event.HprofDumpEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.Date;

public class HprofDumpEndImpl
extends ProfilingPacketImpl
implements HprofDumpEnd {
    private final long timestamp;
    private final long endTime;
    private final long size;
    private final long addonSize;
    private final long nrOfObjects;

    public static HprofDumpEndImpl read(ResourceReader reader, HprofDumpEventHandler[] handlers) throws IOException {
        HprofDumpEndImpl response = new HprofDumpEndImpl(reader);
        for (HprofDumpEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private HprofDumpEndImpl(ResourceReader reader) throws IOException {
        this.timestamp = reader.readInt64();
        this.endTime = reader.readInt64();
        this.size = reader.readInt64();
        this.addonSize = reader.readInt64();
        this.nrOfObjects = reader.readInt64();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.HPROF_DUMP_END_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.format("hprof dump end: size=%*B", this.size, this.size);
        stream.format(", addonSize=%*B", this.addonSize);
        stream.print(", nrOfObjects=" + this.nrOfObjects);
        stream.format(", timestamp=%*t", this.timestamp);
        stream.println(", startTime=" + new Date(this.endTime));
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)669);
        writer.writeInt64(this.timestamp);
        writer.writeInt64(this.endTime);
        writer.writeInt64(this.size);
        writer.writeInt64(this.addonSize);
        writer.writeInt64(this.nrOfObjects);
        writer.finalizePacket();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getAddonSize() {
        return this.addonSize;
    }

    @Override
    public long getNumberOfObjects() {
        return this.nrOfObjects;
    }

    @Override
    public String getPacketName() {
        return "hprof dump end event";
    }
}

