/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.memory.event.HprofDumpEventHandler;
import com.sap.jvm.profiling.memory.event.HprofDumpSeek;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class HprofDumpSeekImpl
extends ProfilingPacketImpl
implements HprofDumpSeek {
    private final long offset;

    public static HprofDumpSeekImpl read(ResourceReader reader, HprofDumpEventHandler[] handlers) throws IOException {
        HprofDumpSeekImpl response = new HprofDumpSeekImpl(reader);
        for (HprofDumpEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private HprofDumpSeekImpl(ResourceReader reader) throws IOException {
        this.offset = reader.readInt64();
    }

    @Override
    public long getSeekOffset() {
        return this.offset;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.HPROF_DUMP_SEEK_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.println("hprof dump seek: offset=" + this.offset);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)671);
        writer.writeInt64(this.offset);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "hprof dump seek event";
    }
}

