/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.memory.event.HprofDumpEventHandler;
import com.sap.jvm.profiling.memory.event.HprofDumpStart;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.Date;

public class HprofDumpStartImpl
extends ProfilingPacketImpl
implements HprofDumpStart {
    private final String name;
    private final boolean includeAddons;
    private final boolean ensureIdsForAllObjects;
    private final boolean forceGcRequested;
    private final boolean forcedGc;
    private final int index;
    private final long timestamp;
    private final long startTime;

    public static HprofDumpStartImpl read(ResourceReader reader, HprofDumpEventHandler[] handlers) throws IOException {
        HprofDumpStartImpl response = new HprofDumpStartImpl(reader);
        for (HprofDumpEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private HprofDumpStartImpl(ResourceReader reader) throws IOException {
        this.timestamp = reader.readInt64();
        this.startTime = reader.readInt64();
        this.name = reader.readString();
        this.includeAddons = reader.readBoolean();
        this.ensureIdsForAllObjects = reader.readBoolean();
        this.forceGcRequested = reader.readBoolean();
        this.forcedGc = reader.readBoolean();
        this.index = reader.readInt32();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.HPROF_DUMP_START_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.print("hprof dump start: name=" + this.name);
        stream.format(", timestamp=%*t", this.timestamp);
        stream.print(", startTime=" + new Date(this.startTime));
        stream.print(", includeAddons=" + this.includeAddons);
        stream.print(", ensureIdsForAllObjects=" + this.ensureIdsForAllObjects);
        stream.print(", forceGcRequested=" + this.forceGcRequested);
        stream.print(", forcedGc=" + this.forcedGc);
        stream.print(", index=" + this.index);
        stream.println();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean includesAddons() {
        return this.includeAddons;
    }

    @Override
    public boolean ensuredIdsForAllObjects() {
        return this.ensureIdsForAllObjects;
    }

    @Override
    public boolean forcedGc() {
        return this.forcedGc;
    }

    @Override
    public int getDumpIndex() {
        return this.index;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)668);
        writer.writeInt64(this.timestamp);
        writer.writeInt64(this.startTime);
        writer.writeString(this.name);
        writer.writeBoolean(this.includeAddons);
        writer.writeBoolean(this.ensureIdsForAllObjects);
        writer.writeBoolean(this.forceGcRequested);
        writer.writeBoolean(this.forcedGc);
        writer.writeInt32(this.index);
        writer.finalizePacket();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean forceGcRequested() {
        return this.forceGcRequested;
    }

    @Override
    public String getPacketName() {
        return "hprof dump start event";
    }
}

