/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.memory.event.HprofDumpEventHandler;
import com.sap.jvm.profiling.memory.event.HprofDumpWrite;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class HprofDumpWriteImpl
extends ProfilingPacketImpl
implements HprofDumpWrite {
    private final long writtenBytes;
    private final long dumpedObjects;
    private final byte[] data;

    public static HprofDumpWriteImpl read(ResourceReader reader, HprofDumpEventHandler[] handlers) throws IOException {
        HprofDumpWriteImpl response = new HprofDumpWriteImpl(reader);
        for (HprofDumpEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private HprofDumpWriteImpl(ResourceReader reader) throws IOException {
        this.writtenBytes = reader.readInt64();
        this.dumpedObjects = reader.readInt64();
        int len = reader.readInt32();
        this.data = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.data[i] = reader.readInt8();
        }
    }

    @Override
    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    @Override
    public long getDumpedObjects() {
        return this.dumpedObjects;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.HPROF_DUMP_WRITE_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.print("hprof dump write: written_bytes=" + this.writtenBytes);
        stream.print(", dumped objects=" + this.dumpedObjects);
        stream.print(", len=" + this.data.length);
        stream.println();
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)670);
        writer.writeInt64(this.writtenBytes);
        writer.writeInt64(this.dumpedObjects);
        writer.writeInt32(this.data.length);
        writer.writeBytes(this.data);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "hprof dump write event";
    }
}

