/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.impl.core.type.ArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.memory.event.AbstractAllocationEventImpl;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class MultiArrayStackAllocationNoStackAndIdEventImpl
extends AbstractAllocationEventImpl {
    private final ArrayClassObjectImpl classObject;
    private final int length;
    private final char threadIndex;
    private final char nrOfAllocations;
    private final byte inlineCount;

    public static MultiArrayStackAllocationNoStackAndIdEventImpl read(ResourceReader reader, AllocationEventHandler[] handlers, boolean[] threadFilterFlags) throws IOException {
        char threadIndex;
        MultiArrayStackAllocationNoStackAndIdEventImpl result = new MultiArrayStackAllocationNoStackAndIdEventImpl(reader);
        if (threadFilterFlags != null && !threadFilterFlags[threadIndex = result.getThreadIndex()]) {
            return null;
        }
        for (AllocationEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public MultiArrayStackAllocationNoStackAndIdEventImpl(ResourceReader reader) throws IOException {
        this.classObject = (ArrayClassObjectImpl)reader.readClassObject();
        this.length = reader.readInt32();
        this.threadIndex = reader.readUint16();
        this.nrOfAllocations = reader.readUint16();
        this.inlineCount = reader.hasNext() ? reader.readInt8() : (byte)0;
        assert (this.length >= 0);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALLOCATION_EVENT;
    }

    @Override
    public ArrayClassObjectImpl getClassObject() {
        return this.classObject;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public long getObjectId() {
        return 0L;
    }

    @Override
    public long getSize() {
        return this.getClassObject().getInstanceSize(this.length);
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getNrOfAllocations() {
        return this.nrOfAllocations;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)779);
        writer.writeInt32(this.classObject.getIndex());
        writer.writeInt32(this.length);
        writer.writeUint16(this.threadIndex);
        writer.writeUint16(this.nrOfAllocations);
        writer.writeInt8(this.inlineCount);
        writer.finalizePacket();
    }

    @Override
    public int getStackTraceIndex() {
        return 0;
    }

    @Override
    public int getNrOfInlinedTopFrames() {
        return this.inlineCount & 0xFF;
    }

    @Override
    public String getPacketName() {
        return "multi array stack allocation without id and stack event";
    }

    @Override
    public boolean isStackAllocation() {
        return true;
    }
}

