/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.memory.event.AbstractAllocationEventImpl;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class MultiNonArrayStackAllocationNoIdEventImpl
extends AbstractAllocationEventImpl {
    private final NonArrayClassObjectImpl classObject;
    private final int stackTraceIndex;
    private final char threadIndex;
    private final char nrOfAllocations;
    private final byte inlineCount;

    public static MultiNonArrayStackAllocationNoIdEventImpl read(ResourceReader reader, AllocationEventHandler[] handlers, boolean[] threadFilterFlags) throws IOException {
        char threadIndex;
        MultiNonArrayStackAllocationNoIdEventImpl result = new MultiNonArrayStackAllocationNoIdEventImpl(reader);
        if (threadFilterFlags != null && !threadFilterFlags[threadIndex = result.getThreadIndex()]) {
            return null;
        }
        for (AllocationEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public MultiNonArrayStackAllocationNoIdEventImpl(ResourceReader reader) throws IOException {
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.classObject = (NonArrayClassObjectImpl)reader.readClassObject();
        this.threadIndex = reader.readUint16();
        this.nrOfAllocations = reader.readUint16();
        this.inlineCount = reader.hasNext() ? reader.readInt8() : (byte)0;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALLOCATION_EVENT;
    }

    @Override
    public NonArrayClassObjectImpl getClassObject() {
        return this.classObject;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public long getObjectId() {
        return 0L;
    }

    @Override
    public long getSize() {
        return this.classObject.getInstanceSize();
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getNrOfAllocations() {
        return this.nrOfAllocations;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)776);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt32(this.classObject.getIndex());
        writer.writeUint16(this.threadIndex);
        writer.writeUint16(this.nrOfAllocations);
        writer.writeInt8(this.inlineCount);
        writer.finalizePacket();
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public int getNrOfInlinedTopFrames() {
        return this.inlineCount & 0xFF;
    }

    @Override
    public String getPacketName() {
        return "multi non-array stack allocation without id event";
    }

    @Override
    public boolean isStackAllocation() {
        return true;
    }
}

