/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.memory.event.AbstractAllocationEventImpl;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class NonArrayAllocationNoStackEventImpl
extends AbstractAllocationEventImpl {
    private final long objectId;
    private final NonArrayClassObjectImpl classObject;
    private final char threadIndex;
    private final byte inlineCount;

    public static NonArrayAllocationNoStackEventImpl read(ResourceReader reader, AllocationEventHandler[] handlers, boolean[] threadFilterFlags) throws IOException {
        char threadIndex;
        NonArrayAllocationNoStackEventImpl result = new NonArrayAllocationNoStackEventImpl(reader);
        if (threadFilterFlags != null && !threadFilterFlags[threadIndex = result.getThreadIndex()]) {
            return null;
        }
        for (AllocationEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public NonArrayAllocationNoStackEventImpl(ResourceReader reader) throws IOException {
        this.objectId = reader.readInt64();
        this.classObject = (NonArrayClassObjectImpl)reader.readClassObject();
        this.threadIndex = reader.readUint16();
        this.inlineCount = reader.hasNext() ? reader.readInt8() : (byte)0;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALLOCATION_EVENT;
    }

    @Override
    public NonArrayClassObjectImpl getClassObject() {
        return this.classObject;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public long getSize() {
        return this.classObject.getInstanceSize();
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getNrOfAllocations() {
        return 1;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)512);
        writer.writeInt64(this.objectId);
        writer.writeInt32(this.classObject.getIndex());
        writer.writeUint16(this.threadIndex);
        writer.writeInt8(this.inlineCount);
        writer.finalizePacket();
    }

    @Override
    public int getStackTraceIndex() {
        return 0;
    }

    @Override
    public int getNrOfInlinedTopFrames() {
        return this.inlineCount & 0xFF;
    }

    @Override
    public String getPacketName() {
        return "non-array allocation without stack event";
    }
}

