/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.memory.event.AbstractAllocationEventImpl;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class NonArrayStackAllocationNoStackAndIdEventImpl
extends AbstractAllocationEventImpl {
    private final NonArrayClassObjectImpl classObject;
    private final char threadIndex;
    private final byte inlineCount;

    public static NonArrayStackAllocationNoStackAndIdEventImpl read(ResourceReader reader, AllocationEventHandler[] handlers, boolean[] threadFilterFlags) throws IOException {
        char threadIndex;
        NonArrayStackAllocationNoStackAndIdEventImpl result = new NonArrayStackAllocationNoStackAndIdEventImpl(reader);
        if (threadFilterFlags != null && !threadFilterFlags[threadIndex = result.getThreadIndex()]) {
            return null;
        }
        for (AllocationEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public NonArrayStackAllocationNoStackAndIdEventImpl(ResourceReader reader) throws IOException {
        this.classObject = (NonArrayClassObjectImpl)reader.readClassObject();
        this.threadIndex = reader.readUint16();
        this.inlineCount = reader.hasNext() ? reader.readInt8() : (byte)0;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALLOCATION_EVENT;
    }

    @Override
    public NonArrayClassObjectImpl getClassObject() {
        return this.classObject;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public long getObjectId() {
        return 0L;
    }

    @Override
    public long getSize() {
        return this.classObject.getInstanceSize();
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getNrOfAllocations() {
        return 1;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)771);
        writer.writeInt32(this.classObject.getIndex());
        writer.writeUint16(this.threadIndex);
        writer.writeInt8(this.inlineCount);
        writer.finalizePacket();
    }

    @Override
    public int getStackTraceIndex() {
        return 0;
    }

    @Override
    public int getNrOfInlinedTopFrames() {
        return this.inlineCount & 0xFF;
    }

    @Override
    public String getPacketName() {
        return "non-array stack allocation without id and stack event";
    }

    @Override
    public boolean isStackAllocation() {
        return true;
    }
}

