/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.memory.event.ObjectDeathEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ObjectDeathEventImpl
extends ProfilingPacketImpl
implements ObjectDeathEvent {
    private final long objectId;

    public ObjectDeathEventImpl(ResourceReader reader) throws IOException {
        this.objectId = reader.readInt64();
        assert (this.objectId >= 0L);
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.OBJECT_DEATH_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Object id: %d", this.objectId);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)522);
        writer.writeInt64(this.objectId);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "object death event";
    }
}

