/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.ClassObjectImpl;
import com.sap.jvm.profiling.impl.memory.event.BasicClassStatisticHelperImpl;
import com.sap.jvm.profiling.memory.AgeRange;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.memory.event.OldGenClassStatistic;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class OldGenClassStatisticImpl
extends ProfilingPacketImpl
implements OldGenClassStatistic {
    private final long gcNr;
    private final AgeRange ageRange;
    private final ClassObjectImpl[] classes;
    private final long[] nrOfObjects;
    private long nrCountOfObjetcsInTotal;
    private final long[] sizeOfObjects;

    public static OldGenClassStatisticImpl read(ResourceReader reader, ClassStatisticEventHandler[] handlers) throws IOException {
        OldGenClassStatisticImpl response = new OldGenClassStatisticImpl(reader);
        for (ClassStatisticEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    public static OldGenClassStatisticImpl read(ResourceReader reader) throws IOException {
        OldGenClassStatisticImpl result = new OldGenClassStatisticImpl(reader);
        return result;
    }

    private OldGenClassStatisticImpl(ResourceReader reader) throws IOException {
        this.gcNr = reader.readInt64();
        int startAge = reader.readInt32();
        int endAge = reader.readInt32();
        int nrOfClasses = reader.readInt32();
        this.ageRange = new AgeRange(startAge, endAge);
        this.classes = new ClassObjectImpl[nrOfClasses];
        this.nrOfObjects = new long[nrOfClasses];
        this.sizeOfObjects = new long[nrOfClasses];
        for (int i = 0; i < nrOfClasses; ++i) {
            this.classes[i] = (ClassObjectImpl)reader.readClassObject();
            this.nrOfObjects[i] = reader.readInt64();
            this.sizeOfObjects[i] = reader.readInt64();
        }
        this.nrCountOfObjetcsInTotal = -1L;
    }

    @Override
    public int getNrOfClasses() {
        return this.classes.length;
    }

    @Override
    public ClassObject getClassObject(int index) {
        return this.classes[index];
    }

    @Override
    public long getNrOfObjects(int index) {
        return this.nrOfObjects[index];
    }

    @Override
    public long getSizeOfObjects(int index) {
        return this.sizeOfObjects[index];
    }

    @Override
    public AgeRange getAgeRange() {
        return this.ageRange;
    }

    @Override
    public long getGCNr() {
        return this.gcNr;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.OLD_GEN_CLASS_STATISTIC_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("GC Nr.    : %d", this.gcNr);
        stream.formatln("Age range : %d - %d", this.ageRange.getLowerLimit(), this.ageRange.getUpperLimit());
        for (int i = 0; i < this.getNrOfClasses(); ++i) {
            stream.formatln("%6d %*C %d objects %*B", i, this.getClassObject(i), this.getNrOfObjects(i), this.getSizeOfObjects(i));
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)503);
        writer.writeInt64(this.gcNr);
        writer.writeInt32(this.ageRange.getLowerLimit());
        writer.writeInt32(this.ageRange.getUpperLimit());
        writer.writeInt32(this.classes.length);
        for (int i = 0; i < this.classes.length; ++i) {
            writer.writeClassObject(this.classes[i]);
            writer.writeInt64(this.nrOfObjects[i]);
            writer.writeInt64(this.sizeOfObjects[i]);
        }
        writer.finalizePacket();
    }

    @Override
    public long getTotalNumOfObjects() {
        if (this.nrCountOfObjetcsInTotal == -1L) {
            this.nrCountOfObjetcsInTotal = BasicClassStatisticHelperImpl.getObjectCount(this);
        }
        return this.nrCountOfObjetcsInTotal;
    }

    @Override
    public String getPacketName() {
        return "old generation class statistic event";
    }
}

