/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.memory.response.ClassStatisticDumpResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ClassStatisticDumpResponseImpl
extends ResponseImpl
implements ClassStatisticDumpResponse {
    private final String name;
    private boolean forceGc = true;
    private long youngGenSize = -1L;
    private long oldGenSize = -1L;
    private long permGenSize = -1L;

    public static ClassStatisticDumpResponseImpl read(ResourceReader reader, ClassStatisticEventHandler[] handlers) throws IOException {
        ClassStatisticDumpResponseImpl response = new ClassStatisticDumpResponseImpl(reader);
        for (ClassStatisticEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private ClassStatisticDumpResponseImpl(ResourceReader reader) throws IOException {
        super("class statistic dump response", reader);
        this.name = reader.readString();
        if (reader.hasNext()) {
            this.forceGc = reader.readBoolean();
        }
        if (reader.hasNext()) {
            this.youngGenSize = reader.readInt64();
            this.oldGenSize = reader.readInt64();
            this.permGenSize = reader.readInt64();
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.DUMP_CLASS_STATISTIC_START_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1062);
        this.writeInternal(writer);
        writer.writeString(this.name);
        writer.writeBoolean(this.forceGc);
        writer.writeInt64(this.youngGenSize);
        writer.writeInt64(this.oldGenSize);
        writer.writeInt64(this.permGenSize);
        writer.finalizePacket();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean forceGcRequested() {
        return this.forceGc;
    }

    @Override
    public long getMaxYoungGenSize() {
        return this.youngGenSize;
    }

    @Override
    public long getMaxOldGenSize() {
        return this.oldGenSize;
    }

    @Override
    public long getMaxPermGenSize() {
        return this.permGenSize;
    }
}

