/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.memory.response.DisableAllocationMptTraceResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class DisableAllocationMptTraceResponseImpl
extends ResponseImpl
implements DisableAllocationMptTraceResponse {
    private final UTF8String allocationErrorMessage;
    private final UTF8String mptErrorMessage;

    public static DisableAllocationMptTraceResponseImpl read(ResourceReader reader, AllocationEventHandler[] handlers) throws IOException {
        DisableAllocationMptTraceResponseImpl retValue = new DisableAllocationMptTraceResponseImpl(reader);
        for (AllocationEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private DisableAllocationMptTraceResponseImpl(ResourceReader reader) throws IOException {
        super("disablle allocation trace plus MPT response", reader);
        boolean allocSuccess = reader.readBoolean();
        this.allocationErrorMessage = allocSuccess ? null : reader.readUTF();
        boolean mptSuccess = reader.readBoolean();
        this.mptErrorMessage = mptSuccess ? null : reader.readUTF();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.DISABLE_ALLOCATION_MPT_TRACE_RESPONSE;
    }

    @Override
    public String getErrorMessage() {
        StringBuilder builder = new StringBuilder();
        if (super.getErrorMessage() != null) {
            builder.append(super.getErrorMessage()).append("\n");
        }
        if (this.allocationErrorMessage != null) {
            builder.append(this.allocationErrorMessage.toString()).append("\n");
        }
        if (this.mptErrorMessage != null) {
            builder.append(this.mptErrorMessage.toString()).append("\n");
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    @Override
    public boolean isSuccess() {
        return this.getErrorMessage() == null;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
    }

    @Override
    public String getAllocationErrorMessage() {
        return this.allocationErrorMessage == null ? null : this.allocationErrorMessage.toString();
    }

    @Override
    public String getMptErrorMessage() {
        return this.mptErrorMessage == null ? null : this.mptErrorMessage.toString();
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1037);
        this.writeInternal(writer);
        writer.writeBoolean(this.allocationErrorMessage == null);
        if (this.allocationErrorMessage != null) {
            writer.writeUTF(this.allocationErrorMessage);
        }
        writer.writeBoolean(this.mptErrorMessage == null);
        if (this.mptErrorMessage != null) {
            writer.writeUTF(this.mptErrorMessage);
        }
        writer.finalizePacket();
    }
}

