/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.memory.response.DumpClassStatisticEndResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class DumpClassStatisticEndResponseImpl
extends ResponseImpl
implements DumpClassStatisticEndResponse {
    private final String name;

    public static DumpClassStatisticEndResponseImpl read(ResourceReader reader, ClassStatisticEventHandler[] handlers) throws IOException {
        DumpClassStatisticEndResponseImpl response = new DumpClassStatisticEndResponseImpl(reader);
        for (ClassStatisticEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    public DumpClassStatisticEndResponseImpl(ResourceReader reader) throws IOException {
        super("dump class statistic end response", reader);
        this.name = reader.readString();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.DUMP_CLASS_STATISTIC_END_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.print("Class statistic dump: name=" + this.name);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1026);
        this.writeInternal(writer);
        writer.writeString(this.name);
        writer.finalizePacket();
    }

    @Override
    public String getName() {
        return new String(this.name.getBytes());
    }
}

