/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterSpecImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterTraceEnableErrorImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationMptTraceResponse;
import com.sap.jvm.profiling.method.response.MethodParameterIncludeType;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.method.response.MethodParameterTraceEnableError;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class EnableAdaptiveAllocationMptTraceResponseImpl
extends ResponseImpl
implements EnableAdaptiveAllocationMptTraceResponse {
    private UTF8String allocationErrorMessage;
    private UTF8String mptErrorMessage;
    private final AllocationTraceConfiguration configuration;
    private ArrayList<MethodParameterSpecImpl> specs;
    private final boolean includeTimeStamp;
    private final boolean includeCpuTime;
    private final boolean includeStackTrace;
    private final boolean includeStackTraceInExitEvents;
    private MethodParameterTraceEnableErrorImpl error;

    public static EnableAdaptiveAllocationMptTraceResponseImpl read(ResourceReader reader, ProfilingCapabilities capabilities, MappingInformation mapInfo, AllocationEventHandler[] handlers) throws IOException {
        EnableAdaptiveAllocationMptTraceResponseImpl response = new EnableAdaptiveAllocationMptTraceResponseImpl(reader, capabilities, mapInfo);
        for (AllocationEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private EnableAdaptiveAllocationMptTraceResponseImpl(ResourceReader reader, ProfilingCapabilities capabilities, MappingInformation mapInfo) throws IOException {
        super("enable adaptive allocation trace and MPT response", reader);
        boolean allocSuccess = reader.readBoolean();
        this.allocationErrorMessage = allocSuccess ? null : reader.readUTF();
        int maxStackTraceSize = reader.readInt32();
        boolean includeLineNrs = reader.readBoolean();
        String classFilter = reader.readString();
        ThreadFilter threadFilter = reader.readNewThreadFilter();
        boolean hideStringResolving = reader.readBoolean();
        boolean hideFinalizerAllocation = reader.readBoolean();
        boolean hideStaticInitializers = reader.readBoolean();
        boolean hideClassLoading = reader.readBoolean();
        boolean allowPacketReordering = reader.readBoolean();
        boolean multiEvents = reader.readBoolean();
        int minSize = reader.readInt32();
        int maxSize = reader.readInt32();
        int increaseCount = reader.readInt32();
        this.configuration = new AllocationTraceConfiguration(AllocationTraceType.ADAPTIVE);
        this.configuration.setMaxStackTraceSize(maxStackTraceSize);
        this.configuration.setAllocatedObjectClassFilter(classFilter);
        this.configuration.setAllocatedObjectThreadFilter(threadFilter);
        this.configuration.setMinSize(minSize);
        this.configuration.setMaxSize(maxSize);
        this.configuration.setIncreaseCount(increaseCount);
        this.configuration.setIncludeLineNrs(includeLineNrs);
        this.configuration.setHideStringResolving(hideStringResolving);
        this.configuration.setHideFinalizerAllocation(hideFinalizerAllocation);
        this.configuration.setHideStaticInitializers(hideStaticInitializers);
        this.configuration.setHideClassLoading(hideClassLoading);
        this.configuration.setAllowPacketReordering(allowPacketReordering);
        this.configuration.setAllowMultiEvents(multiEvents);
        boolean mptSuccess = reader.readBoolean();
        this.mptErrorMessage = mptSuccess ? null : reader.readUTF();
        this.specs = new ArrayList();
        int nrOfSpecs = reader.readInt32();
        this.includeTimeStamp = reader.readBoolean();
        this.includeCpuTime = reader.readBoolean();
        this.includeStackTrace = reader.readBoolean();
        for (int i = 0; i < nrOfSpecs; ++i) {
            String name = reader.readString();
            String description = reader.readString();
            String method = reader.readString();
            byte includeType = reader.readInt8();
            int index = reader.readInt32();
            String parameterType = reader.readString();
            ArrayList<String> modifiers = new ArrayList<String>();
            int nrOfModifiers = reader.readInt32();
            for (int j = 0; j < nrOfModifiers; ++j) {
                modifiers.add(reader.readString());
            }
            MethodParameterSpecImpl spec = new MethodParameterSpecImpl(i + mapInfo.getSpecificationOffset(), name, description, method, index, MethodParameterIncludeType.get(includeType), modifiers, parameterType);
            this.specs.add(spec);
        }
        if (this.isSuccess()) {
            mapInfo.addMethodParameterSpecifications(this.specs);
        } else {
            int errorType = reader.readInt32();
            int specIndex = reader.readInt32();
            int modifierIndex = reader.readInt32();
            String message = reader.readString();
            this.error = new MethodParameterTraceEnableErrorImpl(errorType, message, specIndex, modifierIndex);
        }
        if (reader.hasNext()) {
            this.configuration.setTraceEveryNth(reader.readInt32());
            this.configuration.setOnlyTopPhysicalFrame(reader.readBoolean());
        }
        if (reader.hasNext()) {
            this.configuration.setIncludeInlineCount(reader.readBoolean());
        }
        if (reader.hasNext()) {
            this.configuration.setUseBci(reader.readBoolean());
            this.configuration.setUseNonZeroBci(reader.readBoolean());
        }
        if (reader.hasNext()) {
            this.configuration.setSupportsJRuby(reader.readBoolean());
        }
        this.includeStackTraceInExitEvents = reader.hasNext() ? reader.readBoolean() : this.includeStackTrace;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_ALLOCATION_MPT_TRACE_RESPONSE;
    }

    @Override
    public String getErrorMessage() {
        StringBuilder builder = new StringBuilder();
        if (super.getErrorMessage() != null) {
            builder.append(super.getErrorMessage()).append("\n");
        }
        if (this.allocationErrorMessage != null) {
            builder.append(this.allocationErrorMessage.toString()).append("\n");
        }
        if (this.mptErrorMessage != null) {
            builder.append(this.mptErrorMessage.toString()).append("\n");
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    @Override
    public boolean isSuccess() {
        return this.getErrorMessage() == null;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        ThreadFilter threadFilter = this.configuration.getAllocatedObjectThreadFilter();
        stream.printlnResponseHeader(this);
        stream.formatln("Max stack trace size  : %d", this.configuration.getMaxStackTraceSize());
        stream.formatln("Include line nr.      : %s", this.configuration.isIncludingLineNrs());
        stream.formatln("Class filter          : %s", this.configuration.getAllocatedObjectClassFilter());
        stream.formatln("Thread filter         : %s", threadFilter == null ? "**" : threadFilter.asString());
        stream.formatln("Hide string resolving : %s", this.configuration.isHidingStringResolving());
        stream.formatln("Hide finalizer alloc  : %s", this.configuration.isHidingFinalizerAllocation());
        stream.formatln("Hide <clinit>         : %s", this.configuration.isHidingStaticInitializers());
        stream.formatln("Hide class loading    : %s", this.configuration.isHidingClassLoading());
        stream.formatln("Minimum size          : %*B", this.configuration.getMinSize());
        stream.formatln("Maximum size          : %*B", this.configuration.getMaxSize());
        stream.formatln("Increase count        : %d", this.configuration.getIncreaseCount());
        stream.formatln("Supports JRuby        : %s", this.configuration.supportsJRuby());
        for (int i = 0; i < this.specs.size(); ++i) {
            MethodParameterSpecImpl spec = this.specs.get(i);
            stream.formatln("MPT spec name         : %s", spec.getName());
            stream.formatln("Description           : %s", spec.getDescription());
            stream.formatln("Method to trace       : %s", spec.getMethod());
            stream.formatln("Include type          : %s", new Object[]{spec.getIncludeType()});
            stream.formatln("Parameter index       : %s", spec.getIndex());
            stream.formatln("Parameter type        : %s", spec.getParameterType());
            List<String> modifiers = spec.getModifiers();
            for (int j = 0; j < modifiers.size(); ++j) {
                stream.formatln("Modifier              : %s", modifiers.get(j));
            }
        }
        if (this.mptErrorMessage != null) {
            stream.formatln("MPT error message     : %s", this.error.getMessage());
            if (this.error.getSpecIndex() != -1) {
                stream.formatln("Failed in spec nr.    : %d", this.error.getSpecIndex());
                if (this.error.getModifierIndex() != -1) {
                    stream.formatln("Failed in modifier nr : %d", this.error.getModifierIndex());
                }
            }
        }
    }

    @Override
    public AllocationTraceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getAllocationErrorMessage() {
        return this.allocationErrorMessage == null ? null : this.allocationErrorMessage.toString();
    }

    @Override
    public MethodParameterTraceEnableError getMptError() {
        return this.error;
    }

    @Override
    public String getMptErrorMessage() {
        return this.mptErrorMessage == null ? null : this.mptErrorMessage.toString();
    }

    @Override
    public List<MethodParameterSpec> getParameterSpecs() {
        return new ArrayList<MethodParameterSpec>(this.specs);
    }

    @Override
    public boolean includeCpuTime() {
        return this.includeCpuTime;
    }

    @Override
    public boolean includeStackTrace() {
        return this.includeStackTrace;
    }

    @Override
    public boolean includeStackTraceInExitEvents() {
        return this.includeStackTraceInExitEvents;
    }

    @Override
    public boolean includeTimeStamp() {
        return this.includeTimeStamp;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1036);
        this.writeInternal(writer);
        writer.writeBoolean(this.allocationErrorMessage == null);
        if (this.allocationErrorMessage != null) {
            writer.writeUTF(this.allocationErrorMessage);
        }
        writer.writeInt32(this.configuration.getMaxStackTraceSize());
        writer.writeBoolean(this.configuration.isIncludingLineNrs());
        writer.writeString(this.configuration.getAllocatedObjectClassFilter());
        writer.writeNewThreadFilter(this.configuration.getAllocatedObjectThreadFilter());
        writer.writeBoolean(this.configuration.isHidingStringResolving());
        writer.writeBoolean(this.configuration.isHidingFinalizerAllocation());
        writer.writeBoolean(this.configuration.isHidingStaticInitializers());
        writer.writeBoolean(this.configuration.isHidingClassLoading());
        writer.writeBoolean(this.configuration.isAllowingPacketReordering());
        writer.writeBoolean(this.configuration.isAllowingMultiEvents());
        writer.writeInt32(this.configuration.getMinSize());
        writer.writeInt32(this.configuration.getMaxSize());
        writer.writeInt32(this.configuration.getIncreaseCount());
        writer.writeBoolean(this.mptErrorMessage == null);
        if (this.mptErrorMessage != null) {
            writer.writeUTF(this.mptErrorMessage);
        }
        writer.writeInt32(this.specs.size());
        writer.writeBoolean(this.includeTimeStamp);
        writer.writeBoolean(this.includeCpuTime);
        writer.writeBoolean(this.includeStackTrace);
        for (int i = 0; i < this.specs.size(); ++i) {
            MethodParameterSpecImpl spec = this.specs.get(i);
            writer.writeString(spec.getName());
            writer.writeString(spec.getDescription());
            writer.writeString(spec.getMethod());
            writer.writeInt8(spec.getIncludeType().getType());
            writer.writeInt32(spec.getIndex());
            writer.writeString(spec.getParameterType());
            List<String> modifiers = spec.getModifiers();
            writer.writeInt32(modifiers.size());
            for (String modifier : modifiers) {
                writer.writeString(modifier);
            }
        }
        if (!this.isSuccess()) {
            writer.writeInt32(this.error.getType());
            writer.writeInt32(this.error.getSpecIndex());
            writer.writeInt32(this.error.getModifierIndex());
            writer.writeString(this.error.getMessage());
        }
        writer.writeInt32(this.configuration.getTraceEveryNth());
        writer.writeBoolean(this.configuration.getOnlyTopPhysicalFrame());
        writer.writeBoolean(this.configuration.includeInlineCount());
        writer.writeBoolean(this.configuration.useBci());
        writer.writeBoolean(this.configuration.useNonZeroBci());
        writer.writeBoolean(this.configuration.supportsJRuby());
        writer.writeBoolean(this.includeStackTraceInExitEvents);
        writer.finalizePacket();
    }
}

