/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.memory.response.EnableAllocationTraceResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class EnableAllocationTraceResponseImpl
extends ResponseImpl
implements EnableAllocationTraceResponse {
    private final AllocationTraceConfiguration configuration;

    public static EnableAllocationTraceResponseImpl read(ResourceReader reader, ProfilingCapabilities capabilities, AllocationEventHandler[] handlers) throws IOException {
        EnableAllocationTraceResponseImpl response = new EnableAllocationTraceResponseImpl(reader, capabilities);
        for (AllocationEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private EnableAllocationTraceResponseImpl(ResourceReader reader, ProfilingCapabilities capabilities) throws IOException {
        super("enable allocation trace response", reader);
        AllocationTraceType type;
        int maxStackTraceSize = reader.readInt32();
        boolean includeLineNrs = reader.readBoolean();
        boolean assignObjectId = reader.readBoolean();
        boolean isSilent = reader.readBoolean();
        String classFilter = reader.readString();
        ThreadFilter threadFilter = reader.readThreadFilter();
        boolean hideStringResolving = reader.readBoolean();
        boolean hideFinalizerAllocation = reader.readBoolean();
        boolean hideStaticInitializers = reader.readBoolean();
        boolean hideClassLoading = reader.readBoolean();
        boolean allowPacketReordering = reader.readBoolean();
        boolean multiEvents = reader.readBoolean();
        if (isSilent) {
            assert (assignObjectId);
            type = AllocationTraceType.SILENT;
        } else {
            type = assignObjectId ? AllocationTraceType.WITH_OBJECT_IDS : AllocationTraceType.NO_OBJECT_IDS;
        }
        this.configuration = new AllocationTraceConfiguration(type);
        this.configuration.setMaxStackTraceSize(maxStackTraceSize);
        this.configuration.setAllocatedObjectClassFilter(classFilter);
        this.configuration.setAllocatedObjectThreadFilter(threadFilter);
        this.configuration.setIncludeLineNrs(includeLineNrs);
        this.configuration.setHideStringResolving(hideStringResolving);
        this.configuration.setHideFinalizerAllocation(hideFinalizerAllocation);
        this.configuration.setHideStaticInitializers(hideStaticInitializers);
        this.configuration.setHideClassLoading(hideClassLoading);
        this.configuration.setAllowPacketReordering(allowPacketReordering);
        this.configuration.setAllowMultiEvents(multiEvents);
        if (capabilities.hasAnnotationThreadFilter() && reader.hasNext()) {
            threadFilter = reader.readNewThreadFilter();
            this.configuration.setAllocatedObjectThreadFilter(threadFilter);
        }
        if (reader.hasNext()) {
            this.configuration.setTraceEveryNth(reader.readInt32());
            this.configuration.setOnlyTopPhysicalFrame(reader.readBoolean());
        }
        if (reader.hasNext()) {
            this.configuration.setIncludeInlineCount(reader.readBoolean());
        }
        if (reader.hasNext()) {
            this.configuration.setUseBci(reader.readBoolean());
            this.configuration.setUseNonZeroBci(reader.readBoolean());
        }
        if (reader.hasNext()) {
            this.configuration.setSupportsJRuby(reader.readBoolean());
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_ALLOCATION_TRACE_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        ThreadFilter threadFilter = this.configuration.getAllocatedObjectThreadFilter();
        stream.printlnResponseHeader(this);
        stream.formatln("Max stack trace size  : %d", this.configuration.getMaxStackTraceSize());
        stream.formatln("Include line nr.      : %s", this.configuration.isIncludingLineNrs());
        stream.formatln("Include ids           : %s", this.configuration.getType() == AllocationTraceType.WITH_OBJECT_IDS);
        stream.formatln("Adaptive              : %s", this.configuration.getType() == AllocationTraceType.ADAPTIVE);
        stream.formatln("Class filter          : %s", this.configuration.getAllocatedObjectClassFilter());
        stream.formatln("Thread filter         : %s", threadFilter == null ? "**" : threadFilter.asString());
        stream.formatln("Hide string resolving : %s", this.configuration.isHidingStringResolving());
        stream.formatln("Hide finalizer alloc  : %s", this.configuration.isHidingFinalizerAllocation());
        stream.formatln("Hide <clinit>         : %s", this.configuration.isHidingStaticInitializers());
        stream.formatln("Hide class loading    : %s", this.configuration.isHidingClassLoading());
        stream.formatln("Supports JRuby        : %s", this.configuration.supportsJRuby());
    }

    @Override
    public AllocationTraceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1013);
        this.writeInternal(writer);
        writer.writeInt32(this.configuration.getMaxStackTraceSize());
        writer.writeBoolean(this.configuration.isIncludingLineNrs());
        writer.writeBoolean(this.configuration.getType() != AllocationTraceType.NO_OBJECT_IDS);
        writer.writeBoolean(this.configuration.getType() == AllocationTraceType.SILENT);
        writer.writeString(this.configuration.getAllocatedObjectClassFilter());
        writer.writeThreadFilter(this.configuration.getAllocatedObjectThreadFilter());
        writer.writeBoolean(this.configuration.isHidingStringResolving());
        writer.writeBoolean(this.configuration.isHidingFinalizerAllocation());
        writer.writeBoolean(this.configuration.isHidingStaticInitializers());
        writer.writeBoolean(this.configuration.isHidingClassLoading());
        writer.writeBoolean(this.configuration.isAllowingPacketReordering());
        writer.writeBoolean(this.configuration.isAllowingMultiEvents());
        writer.writeNewThreadFilter(this.configuration.getAllocatedObjectThreadFilter());
        writer.writeInt32(this.configuration.getTraceEveryNth());
        writer.writeBoolean(this.configuration.getOnlyTopPhysicalFrame());
        writer.writeBoolean(this.configuration.includeInlineCount());
        writer.writeBoolean(this.configuration.useBci());
        writer.writeBoolean(this.configuration.useNonZeroBci());
        writer.writeBoolean(this.configuration.supportsJRuby());
        writer.finalizePacket();
    }
}

