/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.memory.AgeRange;
import com.sap.jvm.profiling.memory.response.EnableClassStatisticResponseBase;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public abstract class EnableClassStatisticReponseBaseImpl
extends ResponseImpl
implements EnableClassStatisticResponseBase {
    private final int[] ageRangesFrom;
    private final int[] ageRangesTo;

    public EnableClassStatisticReponseBaseImpl(String name, ResourceReader reader) throws IOException {
        super(name, reader);
        int nrOfAgeRanges = reader.readInt32();
        assert (nrOfAgeRanges > 0);
        this.ageRangesFrom = new int[nrOfAgeRanges];
        this.ageRangesTo = new int[nrOfAgeRanges];
        for (int i = 0; i < nrOfAgeRanges; ++i) {
            this.ageRangesFrom[i] = reader.readInt32();
            this.ageRangesTo[i] = reader.readInt32();
        }
    }

    @Override
    public AgeRange getAgeRange(int index) {
        return new AgeRange(this.ageRangesFrom[index], this.ageRangesTo[index]);
    }

    @Override
    public int getNrOfAgeRanges() {
        return this.ageRangesFrom.length;
    }

    @Override
    protected void writeInternal(ResourceWriter writer) throws IOException {
        super.writeInternal(writer);
        writer.writeInt32(this.ageRangesFrom.length);
        for (int i = 0; i < this.ageRangesFrom.length; ++i) {
            writer.writeInt32(this.ageRangesFrom[i]);
            writer.writeInt32(this.ageRangesTo[i]);
        }
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.formatln("Nr. of age ranges : %d", this.ageRangesFrom.length);
        for (int i = 0; i < this.ageRangesFrom.length; ++i) {
            stream.formatln("Age range         : %d - %d", this.ageRangesFrom[i], this.ageRangesTo[i]);
        }
    }
}

