/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.memory.command.GcTraceConfiguration;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.response.EnableGcStatisticResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class EnableGcStatisticResponseImpl
extends ResponseImpl
implements EnableGcStatisticResponse {
    private GcTraceConfiguration configuration;

    public static EnableGcStatisticResponseImpl read(ResourceReader reader, GcEventHandler[] handlers) throws IOException {
        EnableGcStatisticResponseImpl retValue = new EnableGcStatisticResponseImpl(reader);
        for (GcEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    public EnableGcStatisticResponseImpl(ResourceReader reader) throws IOException {
        super("enable GC statistic response", reader);
        boolean isExact = reader.hasNext() && reader.readBoolean();
        this.configuration = new GcTraceConfiguration();
        this.configuration.setExact(isExact);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_GC_STATISTIC_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.println("Use exact values: " + this.configuration.isExact());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1001);
        this.writeInternal(writer);
        writer.writeBoolean(this.configuration.isExact());
        writer.finalizePacket();
    }

    @Override
    public boolean isExact() {
        return this.configuration.isExact();
    }

    @Override
    public GcTraceConfiguration getConfiguration() {
        return this.configuration;
    }
}

