/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.memory.response.ForceGcResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ForceGcResponseImpl
extends ResponseImpl
implements ForceGcResponse {
    private final boolean maxCompaction;

    public ForceGcResponseImpl(ResourceReader reader) throws IOException {
        super("force GC response", reader);
        this.maxCompaction = reader.hasNext() && reader.readBoolean();
    }

    @Override
    public boolean wasMaxCompaction() {
        return this.maxCompaction;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.FORCE_GC_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.println("Max compaction: " + this.maxCompaction);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1024);
        this.writeInternal(writer);
        writer.writeBoolean(this.maxCompaction);
        writer.finalizePacket();
    }
}

