/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.memory.event.HprofDumpEventHandler;
import com.sap.jvm.profiling.memory.response.HprofDumpResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class HprofDumpResponseImpl
extends ResponseImpl
implements HprofDumpResponse {
    private final String name;
    private final boolean includeAddons;
    private final boolean ensureIdsForAllObjects;
    private final boolean forceGc;

    public static HprofDumpResponseImpl read(ResourceReader reader, HprofDumpEventHandler[] handlers) throws IOException {
        HprofDumpResponseImpl response = new HprofDumpResponseImpl(reader);
        for (HprofDumpEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private HprofDumpResponseImpl(ResourceReader reader) throws IOException {
        super("hprof dump response", reader);
        this.name = reader.readString();
        this.includeAddons = reader.readBoolean();
        this.ensureIdsForAllObjects = reader.readBoolean();
        this.forceGc = reader.readBoolean();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.HPROF_DUMP_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.print("Hprof dump: name=" + this.name);
        stream.print(", includeAddons=" + this.includeAddons);
        stream.print(", ensureIdsForAllObjects=" + this.ensureIdsForAllObjects);
        stream.print(", forceGc=" + this.forceGc);
        stream.println();
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1057);
        this.writeInternal(writer);
        writer.writeString(this.name);
        writer.writeBoolean(this.includeAddons);
        writer.writeBoolean(this.ensureIdsForAllObjects);
        writer.writeBoolean(this.forceGc);
        writer.finalizePacket();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean includesAddons() {
        return this.includeAddons;
    }

    @Override
    public boolean ensuredIdsForAllObjects() {
        return this.ensureIdsForAllObjects;
    }

    @Override
    public boolean forceGcRequested() {
        return this.forceGc;
    }
}

