/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.command;

import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.method.command.EnableMethodParameterTraceCommand;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public final class EnableMethodParameterTraceCommandImpl
extends CommandImpl
implements EnableMethodParameterTraceCommand {
    private final ArrayList<RequestedMethodParameter> specs;
    private final boolean includeTimeStamp;
    private final boolean includeCpuTime;
    private final boolean includeStackTrace;
    private final boolean includeStackTraceInExitEvents;

    public EnableMethodParameterTraceCommandImpl(List<RequestedMethodParameter> specs, boolean includeTimeStamp, boolean includeCpuTime, boolean includeStackTrace, boolean includeStackTraceInExitEvents) {
        this.specs = new ArrayList<RequestedMethodParameter>(specs);
        this.includeTimeStamp = includeTimeStamp;
        this.includeCpuTime = includeCpuTime;
        this.includeStackTrace = includeStackTrace;
        this.includeStackTraceInExitEvents = includeStackTraceInExitEvents;
    }

    @Override
    public void print(PrintStream stream) {
        stream.println("Enable method parameter trace command");
        stream.println("Include time stamps: " + this.includeTimeStamp);
        stream.println("Include CPU time: " + this.includeCpuTime);
        stream.println("Include stack trace: " + this.includeStackTrace);
        stream.println("Include stack trace in exit events: " + this.includeStackTraceInExitEvents);
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 31);
        stream.writeLong(this.getId());
        stream.writeInt(this.specs.size());
        stream.writeBoolean(this.includeTimeStamp);
        stream.writeBoolean(this.includeCpuTime);
        stream.writeBoolean(this.includeStackTrace);
        for (RequestedMethodParameter spec : this.specs) {
            stream.writeUTF(spec.getName());
            stream.writeUTF(spec.getDescription());
            stream.writeUTF(spec.getMethod());
            stream.writeByte(spec.getIncludeType().getType());
            stream.writeInt(spec.getIndex());
            List<String> modifiers = spec.getModifiers();
            stream.writeInt(modifiers.size());
            for (String modifier : modifiers) {
                stream.writeUTF(modifier);
            }
        }
        stream.writeBoolean(this.includeStackTraceInExitEvents);
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_METHOD_PARAMETER_TRACE;
    }
}

