/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.command;

import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.method.command.EnableTimeBasedSamplingCommand;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class EnableTimeBasedSamplingCommandImpl
extends CommandImpl
implements EnableTimeBasedSamplingCommand {
    private final int maxStackTraceSize;
    private final boolean ignoreSleepingThreads;

    EnableTimeBasedSamplingCommandImpl(int maxStackTraceSize, boolean ignoreSleepingThreads) throws IllegalArgumentException {
        this.maxStackTraceSize = maxStackTraceSize;
        if (maxStackTraceSize < -1) {
            throw new IllegalArgumentException("Illegal value of maxStackTraceSize: " + maxStackTraceSize);
        }
        this.ignoreSleepingThreads = ignoreSleepingThreads;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Enable time based sampling (maxStackTraceSize: ");
        stream.print(this.maxStackTraceSize);
        stream.print(", ignoreSleepingThreads: ");
        stream.print(this.ignoreSleepingThreads);
        stream.println(')');
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 21);
        stream.writeLong(this.getId());
        stream.writeInt(this.maxStackTraceSize);
        stream.writeByte(this.ignoreSleepingThreads ? 1 : 0);
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_TIME_BASED_SAMPLING;
    }
}

