/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.command;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.method.command.EnableTimeBasedSamplingMptCommand;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public final class EnableTimeBasedSamplingMptCommandImpl
extends CommandImpl
implements EnableTimeBasedSamplingMptCommand {
    private final int maxStackTraceSize;
    private final boolean ignoreSleepingThreads;
    private final ThreadFilter threadFilter;
    private final boolean smooth;
    private final ArrayList<RequestedMethodParameter> specs;
    private final boolean includeTimeStamp;
    private final boolean includeCpuTime;
    private final boolean includeStackTrace;
    private final boolean includeStackTraceInExitEvents;

    EnableTimeBasedSamplingMptCommandImpl(int maxStackTraceSize, boolean ignoreSleepingThreads, ThreadFilter threadFilter, boolean smooth, List<RequestedMethodParameter> specs, boolean includeTimeStamp, boolean includeCpuTime, boolean includeStackTrace, boolean includeStackTraceInExitEvents) {
        this.maxStackTraceSize = maxStackTraceSize;
        if (maxStackTraceSize < -1) {
            throw new IllegalArgumentException("Illegal value of maxStackTraceSize: " + maxStackTraceSize);
        }
        this.ignoreSleepingThreads = ignoreSleepingThreads;
        this.threadFilter = threadFilter;
        this.smooth = smooth;
        this.specs = new ArrayList<RequestedMethodParameter>(specs);
        this.includeTimeStamp = includeTimeStamp;
        this.includeCpuTime = includeCpuTime;
        this.includeStackTrace = includeStackTrace;
        this.includeStackTraceInExitEvents = includeStackTraceInExitEvents;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Enable time based sampling mpt (maxStackTraceSize: ");
        stream.print(this.maxStackTraceSize);
        stream.print(", ignoreSleepingThreads: ");
        stream.print(this.ignoreSleepingThreads);
        stream.print(", threadFilter: ");
        stream.print(this.threadFilter == null ? "**" : this.threadFilter.asString());
        stream.print(", smooth: ");
        stream.print(this.smooth);
        stream.print(", include time stamps: " + this.includeTimeStamp);
        stream.print(", include CPU time: " + this.includeCpuTime);
        stream.print(", include stack trace: " + this.includeStackTrace);
        stream.print(", include stack trace in exit events: " + this.includeStackTraceInExitEvents);
        stream.println(')');
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 40);
        stream.writeLong(this.getId());
        stream.writeInt(this.maxStackTraceSize);
        stream.writeByte(this.ignoreSleepingThreads ? 1 : 0);
        this.writeThreadFilter(stream, this.threadFilter);
        stream.writeInt(this.specs.size());
        stream.writeBoolean(this.includeTimeStamp);
        stream.writeBoolean(this.includeCpuTime);
        stream.writeBoolean(this.includeStackTrace);
        for (RequestedMethodParameter spec : this.specs) {
            stream.writeUTF(spec.getName());
            stream.writeUTF(spec.getDescription());
            stream.writeUTF(spec.getMethod());
            stream.writeByte(spec.getIncludeType().getType());
            stream.writeInt(spec.getIndex());
            List<String> modifiers = spec.getModifiers();
            stream.writeInt(modifiers.size());
            for (String modifier : modifiers) {
                stream.writeUTF(modifier);
            }
        }
        this.writeNewThreadFilter(stream, this.threadFilter);
        stream.writeBoolean(this.smooth);
        stream.writeBoolean(this.includeStackTraceInExitEvents);
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_TIME_BASED_SAMPLING_MPT;
    }
}

