/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodCoverageEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class MethodCoverageEventImpl
extends ProfilingPacketImpl
implements MethodCoverageEvent {
    private final MethodObjectImpl method;

    public MethodCoverageEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.method = (MethodObjectImpl)reader.readMethodObject();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.METHOD_COVERAGE_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Method : %*M", this.method);
        stream.formatln("Class loader: %*d", this.method.getMethodClass().getClassLoader());
    }

    @Override
    public MethodObjectImpl getMethodObject() {
        return this.method;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)509);
        writer.writeMethodObject(this.method);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "method coverage event";
    }
}

