/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.ClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class MethodParameterApplyErrorEventImpl
extends ProfilingPacketImpl
implements MethodParameterApplyErrorEvent {
    private final int type;
    private final int specIndex;
    private final int modifierIndex;
    private final String error;
    private final ClassObjectImpl clazz;
    private final MethodObjectImpl method;

    public static MethodParameterApplyErrorEventImpl read(ResourceReader reader, MappingInformation mapInfo, MethodParameterEventHandler[] handlers) throws IOException {
        MethodParameterApplyErrorEventImpl retValue = new MethodParameterApplyErrorEventImpl(reader, mapInfo);
        for (MethodParameterEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private MethodParameterApplyErrorEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.type = reader.readInt32();
        this.specIndex = reader.readInt32();
        this.modifierIndex = reader.readInt32();
        this.error = reader.readString();
        this.clazz = (ClassObjectImpl)reader.readClassObject();
        this.method = (MethodObjectImpl)reader.readMethodObject();
    }

    @Override
    public ClassObject getClassObject() {
        return this.clazz;
    }

    @Override
    public String getMessage() {
        return this.error;
    }

    @Override
    public MethodObject getMethodObject() {
        return this.method;
    }

    @Override
    public int getModifierIndex() {
        return this.modifierIndex;
    }

    @Override
    public int getSpecIndex() {
        return this.specIndex;
    }

    @Override
    public int getErrorType() {
        return this.type;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)552);
        writer.writeInt32(this.type);
        writer.writeInt32(this.specIndex);
        writer.writeInt32(this.modifierIndex);
        writer.writeString(this.error);
        writer.writeClassObject(this.clazz);
        writer.writeMethodObject(this.method);
        writer.finalizePacket();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Type            : %d", this.type);
        stream.formatln("Spec index     : %d", this.specIndex);
        stream.formatln("Modifier index : %d", this.modifierIndex);
        stream.formatln("Message        : %s", this.error);
        stream.formatln("Class          : %*C", this.clazz);
        stream.formatln("Method         : %*M", this.method);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.PARAMETER_APPLY_ERROR;
    }

    @Override
    public String getPacketName() {
        return "method parameter apply error event";
    }
}

