/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterSpecImpl;
import com.sap.jvm.profiling.method.event.MethodParameterDefinitions;
import com.sap.jvm.profiling.method.event.MethodParametersDefinition;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.List;

public final class MethodParameterDefinitionEventImpl
extends ProfilingPacketImpl {
    private MethodParametersDefinition definition;

    public MethodParameterDefinitionEventImpl(int index, int specOffset, ResourceReader reader, MethodParameterDefinitions definitions) throws IOException {
        int nrOfSpecs = reader.readInt32();
        MethodParameterSpecImpl[] usedSpecs = new MethodParameterSpecImpl[nrOfSpecs];
        for (int i = 0; i < nrOfSpecs; ++i) {
            int specIndex = reader.readInt32() + specOffset;
            usedSpecs[i] = definitions.getSpec(specIndex);
        }
        this.definition = new MethodParametersDefinition(definitions.getNrOfSpecs(), index, usedSpecs);
        definitions.addDefinition(index, this.definition);
    }

    public int getDefinitionIndex() {
        return this.definition.getDefinitionIndex();
    }

    public int getIndex(MethodParameterSpec spec) {
        return this.definition.getIndex((MethodParameterSpecImpl)spec);
    }

    public int getNrOfSpecs() {
        return this.definition.getNrOfSpecs();
    }

    public MethodParameterSpec getSpec(int index) {
        return this.definition.getSpec(index);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Definition index : %d", this.definition.getDefinitionIndex());
        stream.formatln("Nr. of specs     : %d", this.definition.getNrOfSpecs());
        for (int i = 0; i < this.definition.getNrOfSpecs(); ++i) {
            MethodParameterSpecImpl spec = this.definition.getSpec(i);
            stream.formatln("MPT spec name    : %s", spec.getName());
            stream.formatln("Description      : %s", spec.getDescription());
            stream.formatln("Method to trace  : %s", spec.getMethod());
            stream.formatln("Include type     : %s", new Object[]{spec.getIncludeType()});
            stream.formatln("Parameter index  : %s", spec.getIndex());
            stream.formatln("Parameter type   : %s", spec.getParameterType());
            List<String> modifiers = spec.getModifiers();
            for (int j = 0; j < modifiers.size(); ++j) {
                stream.formatln("Modifier         : %s", modifiers.get(j));
            }
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.METHOD_PARAMETER_SET_DEFINITION_EVENT;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)551);
        writer.writeInt32(this.definition.getDefinitionIndex());
        int nrOfSpecs = this.definition.getNrOfSpecs();
        writer.writeInt32(nrOfSpecs);
        for (int i = 0; i < nrOfSpecs; ++i) {
            writer.writeInt32(this.definition.getSpec(i).getOffset());
        }
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "method parameter definition event";
    }
}

