/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterRawTagHandling;
import com.sap.jvm.profiling.impl.method.parameters.MethodParametersImpl;
import com.sap.jvm.profiling.impl.reader.EntryEventHandler;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodParameterDefinitions;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParametersDefinition;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class MethodParameterEntryEventImpl
extends ProfilingPacketImpl
implements MethodParameterEntryEvent {
    private static final byte OTHER = 0;
    private static final byte INTERPRETER = 1;
    private static final byte INLINED = 2;
    private static final byte COMPILED = 3;
    private static final byte INTERPRETER_NATIVE = 4;
    private static final byte INLINED_NATIVE = 5;
    private static final byte COMPILED_NATIVE = 6;
    private static final byte COMPILED_TIER1 = 7;
    private static final byte INLINED_TIER1 = 8;
    private static final byte COMPILED_NATIVE_TIER1 = 9;
    private static final byte INLINED_NATIVE_TIER1 = 10;
    private final char threadIndex;
    private final long id;
    private final long timeStamp;
    private final long cpuUserTime;
    private final long cpuSystemTime;
    private final int stackTraceIndex;
    private final byte type;
    private final MethodParametersImpl parameters;

    public static MethodParameterEntryEventImpl read(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        MethodParameterEntryEventImpl retValue = new MethodParameterEntryEventImpl(reader, mapInfo);
        handler.handle(retValue);
        return retValue;
    }

    public MethodParameterEntryEventImpl(MappingInformation mapInfo, char threadIndex, MethodParametersImpl parameters, long timeStamp, long cpuUserTime, long cpuSystemTime, int stackTraceIndex, byte type) {
        assert (parameters != null);
        this.threadIndex = threadIndex;
        this.parameters = parameters;
        this.id = mapInfo.getNextMptId();
        this.timeStamp = timeStamp;
        this.cpuUserTime = cpuUserTime;
        this.cpuSystemTime = cpuSystemTime;
        this.stackTraceIndex = stackTraceIndex;
        this.type = type == -1 ? (byte)0 : type;
        mapInfo.getThreadInfo(threadIndex).pushMethodParameterEntryEvent(this);
    }

    private MethodParameterEntryEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.id = reader.readInt64();
        this.timeStamp = reader.readInt64();
        this.cpuUserTime = reader.readInt64();
        this.cpuSystemTime = reader.readInt64();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.threadIndex = reader.readUint16();
        int definitionIndex = reader.readInt32();
        MethodParameterDefinitions definitions = mapInfo.getParameterDefinitions();
        MethodParametersDefinition paramDefinition = definitions.getDefinition(definitionIndex);
        MethodObjectImpl methodObject = (MethodObjectImpl)reader.readMethodObject();
        int nrOfParams = paramDefinition.getNrOfSpecs();
        this.parameters = new MethodParametersImpl(paramDefinition, methodObject);
        for (int i = 0; i < nrOfParams; ++i) {
            this.parameters.addParameter(MethodParameterRawTagHandling.readTaggedParameter(reader, mapInfo));
        }
        mapInfo.getThreadInfo(this.threadIndex).pushMethodParameterEntryEvent(this);
        this.type = reader.hasNext() ? reader.readInt8() : (byte)0;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.METHOD_ENTRY_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Method      : %*M", this.parameters.getMethod());
        stream.formatln("Id          : %d", this.id);
        stream.formatln("Thread      : %*T", this.threadIndex);
        if (this.cpuSystemTime != -1L) {
            stream.formatln("System Time : %*D", this.cpuSystemTime);
        }
        if (this.cpuUserTime != -1L) {
            stream.formatln("User Time   : %*D", this.cpuUserTime);
        }
        if (this.timeStamp != -1L) {
            stream.formatln("Time Stamp  : %*t", this.timeStamp);
        }
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        for (int i = 0; i < this.parameters.getNrOfParameters(); ++i) {
            stream.formatln("Parameter   : %s", this.parameters.getParameter(i).toString() + " (" + (Object)((Object)this.parameters.getParameter(i).getType()) + ")");
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)533);
        writer.writeInt64(this.id);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.cpuUserTime);
        writer.writeInt64(this.cpuSystemTime);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeUint16(this.threadIndex);
        writer.writeInt32(this.parameters.getDefinitionIndex());
        writer.writeInt32(this.parameters.getMethod().getIndex());
        for (int i = 0; i < this.parameters.getNrOfParameters(); ++i) {
            this.parameters.getParameter(i).write(writer);
        }
        writer.writeInt8(this.type);
        writer.finalizePacket();
    }

    @Override
    public MethodParametersImpl getParameters() {
        return this.parameters;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public long getCpuUserTime() {
        return this.cpuUserTime;
    }

    @Override
    public long getCpuSystemTime() {
        return this.cpuSystemTime;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public boolean isCompiled() {
        return this.type == 3;
    }

    @Override
    public boolean isInterpreted() {
        return this.type == 1;
    }

    @Override
    public boolean isCompiledNative() {
        return this.type == 6;
    }

    @Override
    public boolean isCompiledNativeTier1() {
        return this.type == 9;
    }

    @Override
    public boolean isCompiledTier1() {
        return this.type == 7;
    }

    @Override
    public boolean isInlined() {
        return this.type == 2;
    }

    @Override
    public boolean isInlinedNative() {
        return this.type == 5;
    }

    @Override
    public boolean isInlinedNativeTier1() {
        return this.type == 10;
    }

    @Override
    public boolean isInlinedTier1() {
        return this.type == 8;
    }

    @Override
    public boolean isInterpretedNative() {
        return this.type == 4;
    }

    @Override
    public boolean isOther() {
        return this.type == 0;
    }

    @Override
    public long getCpuTime() {
        return this.cpuSystemTime + this.cpuUserTime;
    }

    @Override
    public String getPacketName() {
        return "method parameter trace entry event";
    }
}

