/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterEntryEventImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterRawTagHandling;
import com.sap.jvm.profiling.impl.method.parameters.MethodParametersImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.ArrayList;

public final class MethodParameterExitEventImpl
extends ProfilingPacketImpl
implements MethodParameterExitEvent {
    private static final byte OTHER = 0;
    private static final byte INTERPRETER = 1;
    private static final byte INLINED = 2;
    private static final byte COMPILED = 3;
    private static final byte INTERPRETER_NATIVE = 4;
    private static final byte INLINED_NATIVE = 5;
    private static final byte COMPILED_NATIVE = 6;
    private static final byte COMPILED_TIER1 = 7;
    private static final byte INLINED_TIER1 = 8;
    private static final byte COMPILED_NATIVE_TIER1 = 9;
    private static final byte INLINED_NATIVE_TIER1 = 10;
    private final MethodParameterEntryEventImpl entryEvent;
    private final char threadIndex;
    private final long id;
    private final long timeStamp;
    private final long cpuUserTime;
    private final long cpuSystemTime;
    private final int stackTraceIndex;
    private final byte type;
    private final MethodParametersImpl parameters;

    public static MethodParameterExitEventImpl read(ResourceReader reader, MappingInformation mapInfo, MethodParameterEventHandler[] handlers) throws IOException {
        MethodParameterExitEventImpl result = new MethodParameterExitEventImpl(reader, mapInfo);
        if (result.getParameters() == null) {
            return null;
        }
        for (MethodParameterEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private MethodParameterExitEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.timeStamp = reader.readInt64();
        this.cpuUserTime = reader.readInt64();
        this.cpuSystemTime = reader.readInt64();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.type = reader.hasNext() ? reader.readInt8() : (byte)0;
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(this.threadIndex);
        this.entryEvent = threadInfo.getMethodParameterEntryEvent();
        if (this.entryEvent != null) {
            threadInfo.popMethodParameterEntryEvent();
            this.id = this.entryEvent.getId();
            if (reader.hasNext()) {
                int nrOfParams = reader.readInt8();
                if (nrOfParams == -1) {
                    nrOfParams = reader.readInt32();
                }
                if (nrOfParams > 0) {
                    this.parameters = new MethodParametersImpl(this.entryEvent.getParameters());
                    ArrayList<Parameter> returnValues = new ArrayList<Parameter>(nrOfParams);
                    for (int i = 0; i < nrOfParams; ++i) {
                        returnValues.add(MethodParameterRawTagHandling.readTaggedParameter(reader, mapInfo));
                    }
                    this.parameters.replaceReturnValues(returnValues);
                } else {
                    this.parameters = this.entryEvent.getParameters();
                }
            } else {
                this.parameters = this.entryEvent.getParameters();
            }
        } else {
            this.id = -1L;
            this.parameters = null;
        }
    }

    MethodParameterExitEventImpl(char threadIndex, long timeStamp, long cpuUserTime, long cpuSystemTime, int stackTraceIndex, byte type, MappingInformation mapInfo, ArrayList<Parameter> returnValues) {
        this.timeStamp = timeStamp;
        this.cpuUserTime = cpuUserTime;
        this.cpuSystemTime = cpuSystemTime;
        this.stackTraceIndex = stackTraceIndex;
        this.type = type == -1 ? (byte)0 : type;
        this.threadIndex = threadIndex;
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(threadIndex);
        this.entryEvent = threadInfo.getMethodParameterEntryEvent();
        if (this.entryEvent != null) {
            threadInfo.popMethodParameterEntryEvent();
            this.id = this.entryEvent.getId();
            if (returnValues != null && !returnValues.isEmpty()) {
                this.parameters = new MethodParametersImpl(this.entryEvent.getParameters());
                this.parameters.replaceReturnValues(returnValues);
            } else {
                this.parameters = this.entryEvent.getParameters();
            }
        } else {
            this.id = -1L;
            this.parameters = null;
        }
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.METHOD_EXIT_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Id     : %d", this.id);
        stream.formatln("Thread : %*T", this.threadIndex);
        if (this.cpuSystemTime != -1L) {
            stream.formatln("System Time : %*D", this.cpuSystemTime);
            if (this.entryEvent != null) {
                stream.formatln("Used SysTime: %*D", this.cpuSystemTime - this.entryEvent.getCpuSystemTime());
            }
        }
        if (this.cpuUserTime != -1L) {
            stream.formatln("User Time   : %*D", this.cpuUserTime);
            if (this.entryEvent != null) {
                stream.formatln("Used UrsTime: %*D", this.cpuUserTime - this.entryEvent.getCpuUserTime());
            }
        }
        if (this.timeStamp != -1L) {
            stream.formatln("Time Stamp  : %*t", this.timeStamp);
            if (this.entryEvent != null) {
                stream.formatln("Entry Stamp : %*t", this.entryEvent.getTimeStamp());
                stream.formatln("Elapsed Time: %*D", this.timeStamp - this.entryEvent.getTimeStamp());
            }
        }
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        for (int i = 0; i < this.parameters.getNrOfParameters(); ++i) {
            stream.formatln("Parameter   : %s", this.parameters.getParameter(i).toString());
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        int i;
        writer.initializePacket((short)534);
        writer.writeUint16(this.threadIndex);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.cpuUserTime);
        writer.writeInt64(this.cpuSystemTime);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt8(this.type);
        int nrOfExitValues = 0;
        for (i = 0; i < this.parameters.getNrOfParameters(); ++i) {
            if (this.parameters.getSpec(i).getIndex() != -2) continue;
            ++nrOfExitValues;
        }
        if (nrOfExitValues == 0) {
            writer.writeInt8(0);
        } else {
            if (nrOfExitValues < 128) {
                writer.writeInt8((byte)nrOfExitValues);
            } else {
                writer.writeInt8(-1);
                writer.writeInt32(nrOfExitValues);
            }
            for (i = 0; i < this.parameters.getNrOfParameters(); ++i) {
                if (this.parameters.getSpec(i).getIndex() != -2) continue;
                this.parameters.getParameter(i).write(writer);
            }
        }
        writer.finalizePacket();
    }

    @Override
    public MethodParameterEntryEventImpl getEntryEvent() {
        return this.entryEvent;
    }

    @Override
    public MethodParameters getParameters() {
        return this.parameters;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getCpuUserTime() {
        return this.cpuUserTime;
    }

    @Override
    public long getCpuSystemTime() {
        return this.cpuSystemTime;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public boolean isCompiled() {
        return this.type == 3 || this.type == 6 || this.type == 2 || this.type == 5 || this.type == 7 || this.type == 9 || this.type == 8 || this.type == 10;
    }

    @Override
    public boolean isInterpreted() {
        return this.type == 1 || this.type == 4;
    }

    @Override
    public long getElapsedCpuSystemTime() {
        if (this.entryEvent == null) {
            return 0L;
        }
        return Math.max(0L, this.cpuSystemTime - this.entryEvent.getCpuSystemTime());
    }

    @Override
    public long getElapsedCpuTime() {
        return this.getElapsedCpuSystemTime() + this.getElapsedCpuUserTime();
    }

    @Override
    public long getElapsedCpuUserTime() {
        if (this.entryEvent == null) {
            return 0L;
        }
        return Math.max(0L, this.cpuUserTime - this.entryEvent.getCpuUserTime());
    }

    @Override
    public long getElapsedTime() {
        if (this.entryEvent == null) {
            return 0L;
        }
        return Math.max(0L, this.timeStamp - this.entryEvent.getTimeStamp());
    }

    @Override
    public long getCpuTime() {
        return this.cpuSystemTime + this.cpuUserTime;
    }

    @Override
    public String getPacketName() {
        return "method parameter trace exit event";
    }
}

