/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.event.MethodToTraceHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class MethodParameterMethodToTraceEventImpl
extends ProfilingPacketImpl
implements MethodParameterMethodToTraceEvent {
    private final MethodObject method;
    private final ClassObject clazz;
    private final int definitionIndex;

    public static MethodParameterMethodToTraceEventImpl read(ResourceReader reader, MappingInformation mapInfo, MethodToTraceHandler[] handlers) throws IOException {
        MethodParameterMethodToTraceEventImpl retValue = new MethodParameterMethodToTraceEventImpl(reader, mapInfo);
        for (MethodToTraceHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    public MethodParameterMethodToTraceEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.method = reader.readMethodObject();
        this.clazz = reader.readClassObject();
        this.definitionIndex = mapInfo.getDefinitionIndex(reader.readInt32());
    }

    @Override
    public ClassObject getReceiverClass() {
        return this.clazz;
    }

    @Override
    public int getDefinitionIndex() {
        return this.definitionIndex;
    }

    @Override
    public MethodObject getMethod() {
        return this.method;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.PARAMETER_METHOD_TO_TRACE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Method           : %*M", this.method);
        stream.formatln("Receiver         : %*C", this.clazz);
        stream.formatln("Receiver loader  : %s", this.clazz.getClassLoader().getDisplayName());
        stream.formatln("Definition index : %d", this.definitionIndex);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        boolean finalized = writer.isFinalized();
        if (finalized) {
            writer.initializePacket((short)591);
        }
        writer.writeMethodObject(this.method);
        writer.writeClassObject(this.clazz);
        writer.writeInt32(this.definitionIndex);
        if (finalized) {
            writer.finalizePacket();
        }
    }

    @Override
    public String getPacketName() {
        return "method parameter trace method to trace event";
    }
}

