/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.ClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class MethodParameterNearMissEventImpl
extends ProfilingPacketImpl
implements MethodParameterNearMissEvent {
    private final int missType;
    private final MethodObjectImpl method;
    private final ClassObjectImpl clazz;
    private final double missFactor;
    private final int specIndex;

    public static MethodParameterNearMissEventImpl read(ResourceReader reader, MappingInformation mapInfo, MethodParameterEventHandler[] handlers) throws IOException {
        MethodParameterNearMissEventImpl retValue = new MethodParameterNearMissEventImpl(reader, mapInfo);
        if (retValue.getMissFactor() == 0.0) {
            return null;
        }
        for (MethodParameterEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private MethodParameterNearMissEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.missType = reader.readInt32();
        this.specIndex = reader.readInt32();
        this.missFactor = reader.readDouble();
        switch (this.missType) {
            case 0: {
                this.method = (MethodObjectImpl)reader.readMethodObject();
                this.clazz = (ClassObjectImpl)reader.readClassObject();
                break;
            }
            default: {
                this.method = null;
                this.clazz = null;
            }
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.PARAMETER_NEAR_MISS;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)558);
        writer.writeInt32(this.missType);
        writer.writeInt32(this.specIndex);
        writer.writeDouble(this.missFactor);
        switch (this.missType) {
            case 0: {
                writer.writeMethodObject(this.method);
                writer.writeClassObject(this.clazz);
                break;
            }
        }
        writer.finalizePacket();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Spec index  : %d", this.specIndex);
        stream.formatln("Miss type   : %d", this.missType);
        stream.formatln("Miss factor : %f", this.missFactor);
        stream.formatln("Method      : %*M", this.method);
        stream.formatln("Class       : %*C", this.clazz);
    }

    @Override
    public ClassObject getClassObject() {
        return this.clazz;
    }

    @Override
    public MethodObject getMethodObject() {
        return this.method;
    }

    @Override
    public double getMissFactor() {
        return this.missFactor;
    }

    @Override
    public int getMissType() {
        return this.missType;
    }

    @Override
    public int getSpecIndex() {
        return this.specIndex;
    }

    @Override
    public String getPacketName() {
        return "method parameter trace near miss event";
    }
}

