/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterEntryEventImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterExitEventImpl;
import com.sap.jvm.profiling.impl.reader.EntryEventHandler;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.parameters.BooleanParameter;
import com.sap.jvm.profiling.method.parameters.ByteParameter;
import com.sap.jvm.profiling.method.parameters.CharParameter;
import com.sap.jvm.profiling.method.parameters.ClassCastExceptionParameter;
import com.sap.jvm.profiling.method.parameters.ClassParameter;
import com.sap.jvm.profiling.method.parameters.DoubleParameter;
import com.sap.jvm.profiling.method.parameters.EnableFailedParameter;
import com.sap.jvm.profiling.method.parameters.ExceptionInCallParameter;
import com.sap.jvm.profiling.method.parameters.FloatParameter;
import com.sap.jvm.profiling.method.parameters.IndexOutOfBoundsParameter;
import com.sap.jvm.profiling.method.parameters.IntParameter;
import com.sap.jvm.profiling.method.parameters.LongParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameter;
import com.sap.jvm.profiling.method.parameters.NullInCallParameter;
import com.sap.jvm.profiling.method.parameters.NullParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.method.parameters.ShortParameter;
import com.sap.jvm.profiling.method.parameters.StringParameter;
import com.sap.jvm.profiling.method.parameters.UnknownParameter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class MethodParameterRawTagHandling {
    public static void readEntry(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        char index = reader.readUint16();
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        int definitionIndex = mapInfo.getDefinitionIndex(reader.readUint16());
        threadInfo.setParameterDefinition(mapInfo.getParameterDefinitions().getDefinition(definitionIndex), (MethodObjectImpl)reader.readMethodObject(), 0, (byte)-1);
        threadInfo.setNrOfEntryEventTimes(mapInfo.getNrOfEntryEventTimes());
    }

    public static void readEntryWithStack(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        int stackTraceIndex = reader.readStackTraceIndex();
        char index = reader.readUint16();
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        int definitionIndex = mapInfo.getDefinitionIndex(reader.readUint16());
        MethodObjectImpl method = (MethodObjectImpl)reader.readMethodObject();
        byte type = reader.hasNext() ? (byte)reader.readInt8() : (byte)-1;
        threadInfo.setParameterDefinition(mapInfo.getParameterDefinitions().getDefinition(definitionIndex), method, stackTraceIndex, type);
        threadInfo.setNrOfEntryEventTimes(mapInfo.getNrOfEntryEventTimes());
    }

    public static MethodParameterExitEventImpl readExit(ResourceReader reader, MappingInformation mapInfo, MethodParameterEventHandler[] handlers) throws IOException {
        char index = reader.readUint16();
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        MethodParameterExitEventImpl result = new MethodParameterExitEventImpl(index, threadInfo.getTimeStamp(), threadInfo.getCpuUserTime(), threadInfo.getCpuSystemTime(), 0, -1, mapInfo, threadInfo.getAndRemoveExitParameters());
        for (MethodParameterEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public static MethodParameterExitEventImpl readExitWithStack(ResourceReader reader, MappingInformation mapInfo, MethodParameterEventHandler[] handlers) throws IOException {
        int stackTraceIndex = reader.readStackTraceIndex();
        char index = reader.readUint16();
        byte type = reader.hasNext() ? (byte)reader.readInt8() : (byte)-1;
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        MethodParameterExitEventImpl result = new MethodParameterExitEventImpl(index, threadInfo.getTimeStamp(), threadInfo.getCpuUserTime(), threadInfo.getCpuSystemTime(), stackTraceIndex, type, mapInfo, threadInfo.getAndRemoveExitParameters());
        for (MethodParameterEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private static MethodParameterEntryEventImpl addParameter(Parameter parameter, char threadIndex, MappingInformation mapInfo, EntryEventHandler handler) {
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(threadIndex);
        MethodParameterEntryEventImpl result = threadInfo.addParameter(mapInfo, parameter);
        if (result != null) {
            handler.handle(result);
            return result;
        }
        return null;
    }

    public static MethodParameterEntryEventImpl readBooleanParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        boolean value = reader.readBoolean();
        return MethodParameterRawTagHandling.addParameter(new BooleanParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readByteParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        byte value = reader.readInt8();
        return MethodParameterRawTagHandling.addParameter(new ByteParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readShortParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        short value = reader.readInt16();
        return MethodParameterRawTagHandling.addParameter(new ShortParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readCharParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        char value = reader.readUint16();
        return MethodParameterRawTagHandling.addParameter(new CharParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readIntParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        int value = reader.readInt32();
        return MethodParameterRawTagHandling.addParameter(new IntParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readLongParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        long value = reader.readInt64();
        return MethodParameterRawTagHandling.addParameter(new LongParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readFloatParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        float value = reader.readFloat();
        return MethodParameterRawTagHandling.addParameter(new FloatParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readDoubleParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        double value = reader.readDouble();
        return MethodParameterRawTagHandling.addParameter(new DoubleParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readStringParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        byte[] value = reader.readUTF().getBytes();
        return MethodParameterRawTagHandling.addParameter(new StringParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readClassParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        ClassObject value = reader.readClassObject();
        return MethodParameterRawTagHandling.addParameter(new ClassParameter(value), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readIndexOutOfBoundsParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        return MethodParameterRawTagHandling.addParameter(new IndexOutOfBoundsParameter(), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readClassCastParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        return MethodParameterRawTagHandling.addParameter(new ClassCastExceptionParameter(), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readEnabledFailedParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        return MethodParameterRawTagHandling.addParameter(new EnableFailedParameter(), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readExceptionParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        return MethodParameterRawTagHandling.addParameter(new ExceptionInCallParameter(), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readNullInCallParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        return MethodParameterRawTagHandling.addParameter(new NullInCallParameter(), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readNullParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        return MethodParameterRawTagHandling.addParameter(new NullParameter(), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readUnknownParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        return MethodParameterRawTagHandling.addParameter(new UnknownParameter(), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readMethodParameter(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        MethodObject method = threadInfo.getCurrentMptMethod();
        ClassObject receiverClass = reader.readClassObject();
        return MethodParameterRawTagHandling.addParameter(new MethodParameter(method, receiverClass), index, mapInfo, handler);
    }

    public static MethodParameterEntryEventImpl readEntryCpuTime(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        long cpuUserTime = reader.readInt64();
        long cpuSystemTime = reader.readInt64();
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        MethodParameterEntryEventImpl event = threadInfo.setEntryCpuTime(mapInfo, cpuUserTime, cpuSystemTime);
        if (event != null) {
            handler.handle(event);
        }
        return event;
    }

    public static MethodParameterEntryEventImpl readEntryTimeStamp(ResourceReader reader, MappingInformation mapInfo, EntryEventHandler handler) throws IOException {
        char index = reader.readUint16();
        long timeStamp = reader.readInt64();
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        MethodParameterEntryEventImpl event = threadInfo.setEntryTimeStamp(mapInfo, timeStamp);
        if (event != null) {
            handler.handle(event);
        }
        return event;
    }

    public static void readExitCpuTime(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        char index = reader.readUint16();
        long cpuUserTime = reader.readInt64();
        long cpuSystemTime = reader.readInt64();
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        threadInfo.setExitCpuUserTime(cpuUserTime);
        threadInfo.setExitCpuSystemTime(cpuSystemTime);
    }

    public static void readExitTimeStamp(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        char index = reader.readUint16();
        long timeStamp = reader.readInt64();
        ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(index);
        threadInfo.setExitTimeStamp(timeStamp);
    }

    public static Parameter readTaggedParameter(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        Parameter parameter;
        byte tag = reader.readInt8();
        if (tag == ParameterType.BOOLEAN.getTag()) {
            parameter = new BooleanParameter(reader.readInt8() > 0);
        } else if (tag == ParameterType.BYTE.getTag()) {
            parameter = new ByteParameter(reader.readInt8());
        } else if (tag == ParameterType.SHORT.getTag()) {
            parameter = new ShortParameter(reader.readInt16());
        } else if (tag == ParameterType.CHAR.getTag()) {
            parameter = new CharParameter((char)reader.readInt16());
        } else if (tag == ParameterType.INT.getTag()) {
            parameter = new IntParameter(reader.readInt32());
        } else if (tag == ParameterType.LONG.getTag()) {
            parameter = new LongParameter(reader.readInt64());
        } else if (tag == ParameterType.FLOAT.getTag()) {
            parameter = new FloatParameter(reader.readFloat());
        } else if (tag == ParameterType.DOUBLE.getTag()) {
            parameter = new DoubleParameter(reader.readDouble());
        } else if (tag == ParameterType.STRING.getTag()) {
            parameter = new StringParameter(reader.readUTF().getBytes());
        } else if (tag == ParameterType.CLASS.getTag()) {
            parameter = new ClassParameter(mapInfo.getClassObject(reader.readInt32()));
        } else if (tag == ParameterType.NULL.getTag()) {
            parameter = new NullParameter();
        } else if (tag == ParameterType.NULL_INVOCATION_DURING_CALL.getTag()) {
            parameter = new NullInCallParameter();
        } else if (tag == ParameterType.INDEX_OUT_OF_BOUNDS.getTag()) {
            parameter = new IndexOutOfBoundsParameter();
        } else if (tag == ParameterType.CLASS_CAST_EXCEPTION.getTag()) {
            parameter = new ClassCastExceptionParameter();
        } else if (tag == ParameterType.ENABLE_FAILED.getTag()) {
            parameter = new EnableFailedParameter();
        } else if (tag == ParameterType.UNKNOWN.getTag()) {
            parameter = new UnknownParameter();
        } else if (tag == ParameterType.METHOD.getTag()) {
            parameter = new MethodParameter(reader);
        } else {
            assert (tag == ParameterType.EXCEPTION_DURING_CALL.getTag());
            parameter = new ExceptionInCallParameter();
        }
        return parameter;
    }
}

