/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodTraceEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.util.splitarray.SplitArray8;
import java.io.IOException;

public final class MethodTraceEventImpl
extends ProfilingPacketImpl
implements MethodTraceEvent {
    private final char threadIndex;
    private final byte[] payload;
    private static long exitEvents;
    private static long repParts;
    private static long repCounts;

    public MethodTraceEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        int i;
        this.threadIndex = reader.readUint16();
        SplitArray8 raw = new SplitArray8();
        int index = 0;
        while (reader.hasNext()) {
            raw.resize(index + 1);
            raw.set(index, (int)reader.readInt8());
            ++index;
        }
        this.payload = new byte[(int)raw.size()];
        for (i = 0; i < this.payload.length; ++i) {
            this.payload[i] = (byte)raw.get(i);
        }
        for (i = 0; i < this.payload.length; i += 2) {
            if (this.payload[i] == -1 && this.payload[i + 1] == -1) {
                ++exitEvents;
                continue;
            }
            if (this.payload[i] != -2 || this.payload[i + 1] != -1) continue;
            int count = (this.payload[i + 2] & 0xFF) + 256 * (this.payload[i + 3] & 0xFF);
            exitEvents += (long)count;
            ++repParts;
            repCounts += (long)count;
            i += 6;
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)594);
        writer.writeUint16(this.threadIndex);
        writer.writeBytes(this.payload);
        writer.finalizePacket();
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.METHOD_TRACE_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.println("method trace event (found " + exitEvents + " exit events so far, " + repParts + " repetetive parts, " + 1.0 * (double)repCounts / (double)repParts + " counts per rep on average)");
    }

    @Override
    public String getPacketName() {
        return "method trace event";
    }
}

