/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class TimeBasedSamplingEventImpl
extends ProfilingPacketImpl
implements TimeBasedSamplingEvent,
SessionAssociated {
    private static final int OTHER = 0;
    private static final int INTERPRETER = 1;
    private static final int INLINED = 2;
    private static final int COMPILED = 3;
    private static final int INTERPRETER_NATIVE = 4;
    private static final int INLINED_NATIVE = 5;
    private static final int COMPILED_NATIVE = 6;
    private static final int COMPILED_TIER1 = 7;
    private static final int INLINED_TIER1 = 8;
    private static final int COMPILED_NATIVE_TIER1 = 9;
    private static final int INLINED_NATIVE_TIER1 = 10;
    private final long timeStamp;
    private final long elapsedTime;
    private final int[] stackTraceIndices;
    private final char[] threadIndices;
    private final long[] cpuTimes;
    private final boolean[] isSleeping;
    private final int[] topTypes;
    private final AbstractProfilingSessionImpl session;

    public static TimeBasedSamplingEventImpl readInternal(AbstractProfilingSessionImpl session, MappingInformation mapInfo, ResourceReader reader, TimeBasedSamplingEventHandler[] handlers) throws IOException {
        TimeBasedSamplingEventImpl result = new TimeBasedSamplingEventImpl(reader, mapInfo, session.getCapabilities());
        for (TimeBasedSamplingEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public static TimeBasedSamplingEventImpl readExternal(AbstractProfilingSessionImpl session, MappingInformation mapInfo, ResourceReader reader, TimeBasedSamplingEventHandler[] handlers) throws IOException {
        TimeBasedSamplingEventImpl result = new TimeBasedSamplingEventImpl(reader);
        for (TimeBasedSamplingEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private TimeBasedSamplingEventImpl(ResourceReader reader, MappingInformation mapInfo, ProfilingCapabilities capabilities) throws IOException {
        int i;
        long rawElapsedTime;
        this.session = (AbstractProfilingSessionImpl)reader.getSession();
        long rawTimeStamp = reader.readInt64();
        long lastTimeStamp = mapInfo.getLastTbsTimeStamp();
        if (lastTimeStamp == -1L) {
            lastTimeStamp = rawTimeStamp;
        }
        if ((rawElapsedTime = rawTimeStamp - lastTimeStamp) <= 0L) {
            this.elapsedTime = mapInfo.getAverageTbsSampleDiff();
            this.timeStamp = lastTimeStamp + this.elapsedTime;
        } else {
            this.elapsedTime = rawElapsedTime;
            this.timeStamp = rawTimeStamp;
        }
        mapInfo.setLastTbsTimeStamp(this.timeStamp);
        mapInfo.updateAverageTbsSampleDiff(this.elapsedTime);
        int nrOfThreads = reader.readInt32();
        this.stackTraceIndices = new int[nrOfThreads];
        this.threadIndices = new char[nrOfThreads];
        this.isSleeping = new boolean[nrOfThreads];
        this.topTypes = new int[nrOfThreads];
        this.cpuTimes = new long[nrOfThreads];
        for (i = 0; i < nrOfThreads; ++i) {
            this.threadIndices[i] = reader.readUint16();
            this.stackTraceIndices[i] = reader.readStackTraceIndex();
            this.isSleeping[i] = capabilities.hasSleepingThreadSupportInTimeBasedSampling() ? reader.readBoolean() : false;
        }
        if (capabilities.hasInterpreterInformationInTBS()) {
            for (i = 0; i < nrOfThreads; ++i) {
                this.topTypes[i] = reader.readInt8();
            }
        }
        if (capabilities.getSystemInfo().tbsSupportsCpuTime()) {
            for (i = 0; i < nrOfThreads; ++i) {
                ThreadInfoImpl threadInfo = mapInfo.getThreadInfo(this.threadIndices[i]);
                long newCpuTime = reader.readInt64();
                if (this.isSleeping[i]) {
                    newCpuTime = threadInfo.getTbsCpuTime();
                }
                this.cpuTimes[i] = newCpuTime - threadInfo.getTbsCpuTime();
                threadInfo.setTbsCpuTime(newCpuTime);
            }
        }
    }

    private TimeBasedSamplingEventImpl(ResourceReader reader) throws IOException {
        this.session = (AbstractProfilingSessionImpl)reader.getSession();
        this.timeStamp = reader.readInt64();
        this.elapsedTime = reader.readInt64();
        int nrOfThreads = reader.readInt32();
        this.stackTraceIndices = new int[nrOfThreads];
        this.threadIndices = new char[nrOfThreads];
        this.isSleeping = new boolean[nrOfThreads];
        this.topTypes = new int[nrOfThreads];
        this.cpuTimes = new long[nrOfThreads];
        for (int i = 0; i < nrOfThreads; ++i) {
            this.threadIndices[i] = reader.readUint16();
            this.stackTraceIndices[i] = reader.readStackTraceIndex();
            this.isSleeping[i] = reader.readBoolean();
            this.topTypes[i] = reader.readInt8();
            this.cpuTimes[i] = reader.readInt64();
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.TIME_BASED_SAMPLING_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp           : %*r", this.timeStamp);
        stream.formatln("Elapsed time        : %*D", this.getElapsedTime());
        for (int i = 0; i < this.stackTraceIndices.length; ++i) {
            stream.formatln("Thread              : %*T", this.threadIndices[i]);
            stream.formatln("Stack trace         : %*S", this.stackTraceIndices[i]);
            stream.formatln("Elapsed CPU Time    : %*D", this.getElapsedCpuTime(i));
            stream.formatln("Is sleeping         : %s", this.isSleeping(i));
            stream.formatln("TOS compiled        : %s", this.topIsCompiled(i));
            stream.formatln("TOS inlined         : %s", this.topIsInlined(i));
            stream.formatln("TOS interp          : %s", this.topIsInterpreter(i));
            stream.formatln("TOS native compiled : %s", this.topIsNativeCompiled(i));
            stream.formatln("TOS native inlined  : %s", this.topIsNativeInlined(i));
            stream.formatln("TOS native interp   : %s", this.topIsNativeInterpreter(i));
        }
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getNrOfThreads() {
        return this.stackTraceIndices.length;
    }

    @Override
    public char getThreadIndex(int index) {
        return this.threadIndices[index];
    }

    @Override
    public boolean isSleeping(int index) {
        return this.isSleeping[index];
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)610);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.elapsedTime);
        writer.writeInt32(this.threadIndices.length);
        for (int i = 0; i < this.threadIndices.length; ++i) {
            writer.writeUint16(this.threadIndices[i]);
            writer.writeInt32(this.stackTraceIndices[i]);
            writer.writeBoolean(this.isSleeping(i));
            writer.writeInt8(this.topTypes[i]);
            writer.writeInt64(this.cpuTimes[i]);
        }
        writer.finalizePacket();
    }

    @Override
    public int getStackTraceIndex(int index) {
        return this.stackTraceIndices[index];
    }

    @Override
    public boolean topIsInterpreter(int index) {
        return this.topTypes[index] == 1;
    }

    @Override
    public boolean topIsCompiled(int index) {
        return this.topTypes[index] == 3;
    }

    @Override
    public boolean topIsInlined(int index) {
        return this.topTypes[index] == 2;
    }

    @Override
    public boolean topIsOther(int index) {
        return this.topTypes[index] == 0;
    }

    @Override
    public boolean topIsNative(int index) {
        switch (this.topTypes[index]) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean topIsNativeCompiled(int index) {
        return this.topTypes[index] == 6;
    }

    @Override
    public boolean topIsNativeInlined(int index) {
        return this.topTypes[index] == 5;
    }

    @Override
    public boolean topIsNativeInterpreter(int index) {
        return this.topTypes[index] == 4;
    }

    @Override
    public boolean topIsCompiledTier1(int index) {
        return this.topTypes[index] == 7;
    }

    @Override
    public boolean topIsInlinedTier1(int index) {
        return this.topTypes[index] == 8;
    }

    @Override
    public boolean topIsNativeCompiledTier1(int index) {
        return this.topTypes[index] == 9;
    }

    @Override
    public boolean topIsNativeInlinedTier1(int index) {
        return this.topTypes[index] == 10;
    }

    @Override
    public boolean topIsTier1(int index) {
        return this.topTypes[index] == 7 || this.topTypes[index] == 9 || this.topTypes[index] == 8 || this.topTypes[index] == 10;
    }

    @Override
    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public long getElapsedCpuTime(int index) {
        return this.cpuTimes[index];
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public String getPacketName() {
        return "time based sampling event";
    }
}

