/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingInitialCpuTimesEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class TimeBasedSamplingInitialCpuTimesEventImpl
extends ProfilingPacketImpl
implements TimeBasedSamplingInitialCpuTimesEvent {
    private final char[] threadIndices;
    private final long[] cpuTimes;
    private final long timeStamp;

    public static TimeBasedSamplingInitialCpuTimesEventImpl read(AbstractProfilingSessionImpl session, MappingInformation mapInfo, ResourceReader reader) throws IOException {
        TimeBasedSamplingInitialCpuTimesEventImpl result = new TimeBasedSamplingInitialCpuTimesEventImpl(reader, mapInfo);
        return result;
    }

    private TimeBasedSamplingInitialCpuTimesEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.timeStamp = reader.readInt64();
        mapInfo.setLastTbsTimeStamp(this.timeStamp);
        int nrOfThreads = reader.readInt32();
        this.threadIndices = new char[nrOfThreads];
        this.cpuTimes = new long[nrOfThreads];
        for (int i = 0; i < nrOfThreads; ++i) {
            this.threadIndices[i] = reader.readUint16();
            this.cpuTimes[i] = reader.readInt64();
            mapInfo.getThreadInfo(this.threadIndices[i]).setTbsCpuTime(this.cpuTimes[i]);
        }
    }

    @Override
    public long getCPUTime(int index) {
        return this.cpuTimes[index];
    }

    @Override
    public int getNrOfThreads() {
        return this.threadIndices.length;
    }

    @Override
    public char getThreadIndex(int index) {
        return this.threadIndices[index];
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.TIME_BASED_SAMPLING_INITIAL_CPU_TIMES_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp : %*r", this.timeStamp);
        for (int i = 0; i < this.threadIndices.length; ++i) {
            stream.formatln("Thread    : %*T", this.threadIndices[i]);
            stream.formatln("CPU time  : %*D", this.cpuTimes[i]);
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)559);
        writer.writeInt64(this.timeStamp);
        writer.writeInt32(this.threadIndices.length);
        for (int i = 0; i < this.threadIndices.length; ++i) {
            writer.writeUint16(this.threadIndices[i]);
            writer.writeInt64(this.cpuTimes[i]);
        }
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "time based sampling event initial CPU time event";
    }
}

