/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.parameters;

import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterSpecImpl;
import com.sap.jvm.profiling.method.event.MethodParametersDefinition;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public final class MethodParametersImpl
implements MethodParameters {
    private final MethodParametersDefinition definition;
    private int nextIndex;
    private final Parameter[] parameters;
    private final MethodObjectImpl method;

    public MethodParametersImpl(MethodParametersDefinition definition, MethodObjectImpl method) {
        this.definition = definition;
        this.parameters = new Parameter[definition.getNrOfSpecs()];
        this.method = method;
    }

    public MethodParametersImpl(MethodParametersImpl toCopy) {
        this.definition = toCopy.definition;
        this.parameters = (Parameter[])toCopy.parameters.clone();
        this.method = toCopy.method;
        this.nextIndex = toCopy.nextIndex;
    }

    public boolean addParameter(Parameter toAdd) {
        this.parameters[this.nextIndex] = toAdd;
        ++this.nextIndex;
        return this.nextIndex == this.parameters.length;
    }

    @Override
    public boolean containsSpec(MethodParameterSpec spec) {
        return this.containsSpec((MethodParameterSpecImpl)spec);
    }

    public boolean containsSpec(MethodParameterSpecImpl spec) {
        return this.definition.getIndex(spec) >= 0;
    }

    @Override
    public int getNrOfParameters() {
        return this.parameters.length;
    }

    @Override
    public Parameter getParameter(int index) {
        assert (this.nextIndex == this.parameters.length);
        return this.parameters[index];
    }

    public void replaceReturnValues(ArrayList<Parameter> returnValues) {
        int patchOffset = 0;
        for (int i = 0; i < returnValues.size(); ++i) {
            while (this.definition.getSpec(patchOffset).getIndex() != -2) {
                ++patchOffset;
            }
            this.parameters[patchOffset] = returnValues.get(i);
            ++patchOffset;
        }
    }

    @Override
    public Parameter getParameter(MethodParameterSpec spec) {
        return this.getParameter((MethodParameterSpecImpl)spec);
    }

    public Parameter getParameter(MethodParameterSpecImpl spec) {
        assert (this.nextIndex == this.parameters.length);
        int index = this.definition.getIndex(spec);
        if (index >= 0) {
            return this.parameters[index];
        }
        return null;
    }

    @Override
    public MethodParameterSpec getSpec(int index) {
        return this.definition.getSpec(index);
    }

    @Override
    public MethodObjectImpl getMethod() {
        return this.method;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MethodParametersImpl) {
            MethodParametersImpl tmp = (MethodParametersImpl)obj;
            if (!tmp.getMethod().equals(this.method)) {
                return false;
            }
            Parameter[] tmpParams = tmp.parameters;
            if (tmpParams.length != this.parameters.length) {
                return false;
            }
            for (int i = 0; i < this.parameters.length; ++i) {
                if (tmpParams[i].equals(this.parameters[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.method.hashCode();
        return hash ^= Arrays.hashCode(this.parameters);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(this.method.toString());
        for (int i = 0; i < this.parameters.length; ++i) {
            tmp.append(",");
            tmp.append(this.parameters[i]);
        }
        return tmp.toString();
    }

    public int getDefinitionIndex() {
        return this.definition.getDefinitionIndex();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt16((short)this.getDefinitionIndex());
        writer.writeInt32(this.nextIndex);
        writer.writeInt32(this.method.getIndex());
        writer.writeInt32(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].write(writer);
        }
    }
}

