/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class DisableTimeBasedSamplingMptResponseImpl
extends ResponseImpl
implements DisableTimeBasedSamplingMptResponse {
    private final UTF8String tbsErrorMessage;
    private final UTF8String mptErrorMessage;

    public static DisableTimeBasedSamplingMptResponseImpl read(ResourceReader reader, TimeBasedSamplingEventHandler[] handlers) throws IOException {
        DisableTimeBasedSamplingMptResponseImpl retValue = new DisableTimeBasedSamplingMptResponseImpl(reader);
        for (TimeBasedSamplingEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private DisableTimeBasedSamplingMptResponseImpl(ResourceReader reader) throws IOException {
        super("disable time based sampling plus MPT response", reader);
        boolean tbsSuccess = reader.readBoolean();
        this.tbsErrorMessage = tbsSuccess ? null : reader.readUTF();
        boolean mptSuccess = reader.readBoolean();
        this.mptErrorMessage = mptSuccess ? null : reader.readUTF();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.DISABLE_TIME_BASED_SAMPLING_MPT_RESPONSE;
    }

    @Override
    public String getErrorMessage() {
        StringBuilder builder = new StringBuilder();
        if (super.getErrorMessage() != null) {
            builder.append(super.getErrorMessage()).append("\n");
        }
        if (this.tbsErrorMessage != null) {
            builder.append(this.tbsErrorMessage.toString()).append("\n");
        }
        if (this.mptErrorMessage != null) {
            builder.append(this.mptErrorMessage.toString()).append("\n");
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    @Override
    public boolean isSuccess() {
        return this.getErrorMessage() == null;
    }

    @Override
    public String getMptErrorMessage() {
        return this.mptErrorMessage != null ? this.mptErrorMessage.toString() : null;
    }

    @Override
    public String getTbsErrorMessage() {
        return this.tbsErrorMessage != null ? this.tbsErrorMessage.toString() : null;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1039);
        this.writeInternal(writer);
        writer.writeBoolean(this.tbsErrorMessage == null);
        if (this.tbsErrorMessage != null) {
            writer.writeUTF(this.tbsErrorMessage);
        }
        writer.writeBoolean(this.mptErrorMessage == null);
        if (this.mptErrorMessage != null) {
            writer.writeUTF(this.mptErrorMessage);
        }
        writer.finalizePacket();
    }
}

