/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.method.response.EnableMethodCoverageResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class EnableMethodCoverageResponseImpl
extends ResponseImpl
implements EnableMethodCoverageResponse {
    private final String classFilter;

    public EnableMethodCoverageResponseImpl(ResourceReader reader) throws IOException {
        super("enable method coverage response", reader);
        this.classFilter = reader.readString();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_METHOD_COVERAGE_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.formatln("Class filter : %s", this.classFilter);
    }

    public String getClassFilterPattern() {
        return this.classFilter;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1011);
        this.writeInternal(writer);
        writer.writeString(this.getClassFilterPattern());
        writer.finalizePacket();
    }
}

