/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterSpecImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterTraceEnableErrorImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.MethodParameterIncludeType;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class EnableMethodParameterTraceResponseImpl
extends ResponseImpl
implements EnableMethodParameterTraceResponse {
    private ArrayList<MethodParameterSpecImpl> specs = new ArrayList();
    private final boolean includeTimeStamp;
    private final boolean includeCpuTime;
    private final boolean includeStackTrace;
    private final boolean includeStackTraceInExitEvents;
    private MethodParameterTraceEnableErrorImpl error;

    public static EnableMethodParameterTraceResponseImpl read(ResourceReader reader, MappingInformation mapInfo, MethodParameterEventHandler[] handlers) throws IOException {
        EnableMethodParameterTraceResponseImpl retValue = new EnableMethodParameterTraceResponseImpl(reader, mapInfo);
        mapInfo.setNrOfEntryEventTimes((retValue.includeCpuTime ? 1 : 0) + (retValue.includeTimeStamp ? 1 : 0));
        for (MethodParameterEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableMethodParameterTraceResponseImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        super("enable method parameter trace response", reader);
        int nrOfSpecs = reader.readInt32();
        this.includeTimeStamp = reader.readBoolean();
        this.includeCpuTime = reader.readBoolean();
        this.includeStackTrace = reader.readBoolean();
        for (int i = 0; i < nrOfSpecs; ++i) {
            String name = reader.readString();
            String description = reader.readString();
            String method = reader.readString();
            byte includeType = reader.readInt8();
            int index = reader.readInt32();
            String parameterType = reader.readString();
            ArrayList<String> modifiers = new ArrayList<String>();
            int nrOfModifiers = reader.readInt32();
            for (int j = 0; j < nrOfModifiers; ++j) {
                modifiers.add(reader.readString());
            }
            MethodParameterSpecImpl spec = new MethodParameterSpecImpl(i + mapInfo.getSpecificationOffset(), name, description, method, index, MethodParameterIncludeType.get(includeType), modifiers, parameterType);
            this.specs.add(spec);
        }
        if (this.isSuccess()) {
            mapInfo.addMethodParameterSpecifications(this.specs);
        } else {
            int type = reader.readInt32();
            int specIndex = reader.readInt32();
            int modifierIndex = reader.readInt32();
            String message = reader.readString();
            this.error = new MethodParameterTraceEnableErrorImpl(type, message, specIndex, modifierIndex);
        }
        this.includeStackTraceInExitEvents = reader.hasNext() ? reader.readBoolean() : this.includeStackTrace;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_METHOD_PARAMETER_TRACE_RESPONSE;
    }

    @Override
    public List<MethodParameterSpec> getParameterSpecs() {
        return new ArrayList<MethodParameterSpec>(this.specs);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.formatln("Inclde time stamp   : %s", this.includeTimeStamp);
        stream.formatln("Include CPU time    : %s", this.includeCpuTime);
        stream.formatln("Inlcude stack trace : %s", this.includeStackTrace);
        stream.formatln("Inlcude stack trace in exit events: %s", this.includeStackTraceInExitEvents);
        for (int i = 0; i < this.specs.size(); ++i) {
            MethodParameterSpecImpl spec = this.specs.get(i);
            stream.formatln("MPT spec name         : %s", spec.getName());
            stream.formatln("Description           : %s", spec.getDescription());
            stream.formatln("Method to trace       : %s", spec.getMethod());
            stream.formatln("Include type          : %s", new Object[]{spec.getIncludeType()});
            stream.formatln("Parameter index       : %s", spec.getIndex());
            stream.formatln("Parameter type        : %s", spec.getParameterType());
            List<String> modifiers = spec.getModifiers();
            for (int j = 0; j < modifiers.size(); ++j) {
                stream.formatln("Modifier              : %s", modifiers.get(j));
            }
        }
        if (this.error != null) {
            stream.formatln("MPT error message     : %s", this.error.getMessage());
            if (this.error.getSpecIndex() != -1) {
                stream.formatln("Failed in spec nr.    : %d", this.error.getSpecIndex());
                if (this.error.getModifierIndex() != -1) {
                    stream.formatln("Failed in modifier nr : %d", this.error.getModifierIndex());
                }
            }
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1030);
        this.writeInternal(writer);
        writer.writeInt32(this.specs.size());
        writer.writeBoolean(this.includeTimeStamp);
        writer.writeBoolean(this.includeCpuTime);
        writer.writeBoolean(this.includeStackTrace);
        for (int i = 0; i < this.specs.size(); ++i) {
            MethodParameterSpecImpl spec = this.specs.get(i);
            writer.writeString(spec.getName());
            writer.writeString(spec.getDescription());
            writer.writeString(spec.getMethod());
            writer.writeInt8(spec.getIncludeType().getType());
            writer.writeInt32(spec.getIndex());
            writer.writeString(spec.getParameterType());
            List<String> modifiers = spec.getModifiers();
            writer.writeInt32(modifiers.size());
            for (String modifier : modifiers) {
                writer.writeString(modifier);
            }
        }
        if (!this.isSuccess()) {
            writer.writeInt32(this.error.getType());
            writer.writeInt32(this.error.getSpecIndex());
            writer.writeInt32(this.error.getModifierIndex());
            writer.writeString(this.error.getMessage());
        }
        writer.writeBoolean(this.includeStackTraceInExitEvents);
        writer.finalizePacket();
    }

    @Override
    public MethodParameterTraceEnableErrorImpl getError() {
        assert (!this.isSuccess());
        return this.error;
    }

    @Override
    public boolean includeCpuTime() {
        return this.includeCpuTime;
    }

    @Override
    public boolean includeTimeStamp() {
        return this.includeTimeStamp;
    }

    @Override
    public boolean includeStackTrace() {
        return this.includeStackTrace;
    }

    @Override
    public boolean includeStackTraceInExitEvents() {
        return this.includeStackTraceInExitEvents;
    }
}

