/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.response;

import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterSpecImpl;
import com.sap.jvm.profiling.impl.method.response.MethodParameterTraceEnableErrorImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.command.TimeBasedSamplingConfiguration;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.MethodParameterIncludeType;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.method.response.MethodParameterTraceEnableError;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class EnableTimeBasedSamplingMptResponseImpl
extends ResponseImpl
implements EnableTimeBasedSamplingMptResponse {
    private UTF8String tbsErrorMessage;
    private UTF8String mptErrorMessage;
    private final TimeBasedSamplingConfiguration tbsConfiguration = new TimeBasedSamplingConfiguration();
    private ArrayList<MethodParameterSpecImpl> specs;
    private final boolean includeTimeStamp;
    private final boolean includeCpuTime;
    private final boolean includeStackTrace;
    private final boolean includeStackTraceInExitEvents;
    private MethodParameterTraceEnableErrorImpl error;
    private boolean smoothRequestedButFailed;

    public static EnableTimeBasedSamplingMptResponseImpl read(ResourceReader reader, MappingInformation mapInfo, ProfilingCapabilities capabilities, TimeBasedSamplingEventHandler[] handlers) throws IOException {
        EnableTimeBasedSamplingMptResponseImpl retValue = new EnableTimeBasedSamplingMptResponseImpl(reader, mapInfo, capabilities);
        for (TimeBasedSamplingEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableTimeBasedSamplingMptResponseImpl(ResourceReader reader, MappingInformation mapInfo, ProfilingCapabilities capabilities) throws IOException {
        super("enable time base sampling plus MPT response", reader);
        mapInfo.setLastTbsTimeStamp(-1L);
        mapInfo.resetAverageTbsSampleDiff();
        boolean tbsSuccess = reader.readBoolean();
        this.tbsErrorMessage = tbsSuccess ? null : reader.readUTF();
        this.tbsConfiguration.setMaxStackTraceSize(reader.readInt32());
        this.tbsConfiguration.setIgnoreSleepingThreads(reader.readBoolean());
        if (capabilities.hasThreadFilterInTimeBasedSampling()) {
            this.tbsConfiguration.setThreadFilter(reader.readThreadFilter());
        } else if (!this.tbsConfiguration.ignoreSleepingThreads()) {
            throw new UnsupportedOperationException("Sampling of sleeping threads is not supported by the profiled VM. In order to sample sleeping threads update the profiled VM to a current version.");
        }
        boolean mptSuccess = reader.readBoolean();
        this.mptErrorMessage = mptSuccess ? null : reader.readUTF();
        this.specs = new ArrayList();
        int nrOfSpecs = reader.readInt32();
        this.includeTimeStamp = reader.readBoolean();
        this.includeCpuTime = reader.readBoolean();
        this.includeStackTrace = reader.readBoolean();
        for (int i = 0; i < nrOfSpecs; ++i) {
            String name = reader.readString();
            String description = reader.readString();
            String method = reader.readString();
            byte includeType = reader.readInt8();
            int index = reader.readInt32();
            String parameterType = reader.readString();
            ArrayList<String> modifiers = new ArrayList<String>();
            int nrOfModifiers = reader.readInt32();
            for (int j = 0; j < nrOfModifiers; ++j) {
                modifiers.add(reader.readString());
            }
            MethodParameterSpecImpl spec = new MethodParameterSpecImpl(i + mapInfo.getSpecificationOffset(), name, description, method, index, MethodParameterIncludeType.get(includeType), modifiers, parameterType);
            this.specs.add(spec);
        }
        if (this.isSuccess()) {
            mapInfo.addMethodParameterSpecifications(this.specs);
            mapInfo.setNrOfEntryEventTimes((this.includeCpuTime ? 1 : 0) + (this.includeTimeStamp ? 1 : 0));
        } else {
            int errorType = reader.readInt32();
            int specIndex = reader.readInt32();
            int modifierIndex = reader.readInt32();
            String message = reader.readString();
            this.error = new MethodParameterTraceEnableErrorImpl(errorType, message, specIndex, modifierIndex);
        }
        if (capabilities.hasAnnotationThreadFilter() && reader.hasNext()) {
            this.tbsConfiguration.setThreadFilter(reader.readNewThreadFilter());
            if (reader.hasNext()) {
                this.tbsConfiguration.setSmooth(reader.readBoolean());
            }
            if (reader.hasNext()) {
                this.smoothRequestedButFailed = reader.readBoolean();
            }
            this.includeStackTraceInExitEvents = reader.hasNext() ? reader.readBoolean() : this.includeStackTrace;
        } else {
            this.includeStackTraceInExitEvents = this.includeStackTrace;
        }
    }

    @Override
    public String getErrorMessage() {
        StringBuilder builder = new StringBuilder();
        if (super.getErrorMessage() != null) {
            builder.append(super.getErrorMessage()).append("\n");
        }
        if (this.tbsErrorMessage != null) {
            builder.append(this.tbsErrorMessage.toString()).append("\n");
        }
        if (this.mptErrorMessage != null) {
            builder.append(this.mptErrorMessage.toString()).append("\n");
        }
        if (builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    @Override
    public boolean isSuccess() {
        return this.getErrorMessage() == null;
    }

    @Override
    public TimeBasedSamplingConfiguration getTbsConfiguration() {
        return this.tbsConfiguration;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_TIME_BASED_SAMPLING_MPT_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        ThreadFilter threadFilter = this.tbsConfiguration.getThreadFilter();
        stream.printlnResponseHeader(this);
        stream.formatln("Max stack trace size    : %d", this.tbsConfiguration.getMaxStackTraceSize());
        stream.formatln("Ignore sleeping threads : %s", this.tbsConfiguration.ignoreSleepingThreads());
        stream.formatln("Thread filter           : %s", threadFilter == null ? "**" : threadFilter.asString());
        stream.formatln("Smooth                  : %s", this.tbsConfiguration.getSmooth());
        stream.formatln("Include time stamp      : %s", this.includeTimeStamp);
        stream.formatln("Include CPU time        : %s", this.includeCpuTime);
        stream.formatln("Include stack trace     : %s", this.includeStackTrace);
        stream.formatln("Include stack trace in exit events : %s", this.includeStackTraceInExitEvents);
        for (int i = 0; i < this.specs.size(); ++i) {
            MethodParameterSpecImpl spec = this.specs.get(i);
            stream.formatln("MPT spec name           : %s", spec.getName());
            stream.formatln("Description             : %s", spec.getDescription());
            stream.formatln("Method to trace         : %s", spec.getMethod());
            stream.formatln("Include type            : %s", new Object[]{spec.getIncludeType()});
            stream.formatln("Parameter index         : %s", spec.getIndex());
            stream.formatln("Parameter type          : %s", spec.getParameterType());
            List<String> modifiers = spec.getModifiers();
            for (int j = 0; j < modifiers.size(); ++j) {
                stream.formatln("Modifier                : %s", modifiers.get(j));
            }
        }
        if (this.mptErrorMessage != null) {
            stream.formatln("MPT error message       : %s", this.error.getMessage());
            if (this.error.getSpecIndex() != -1) {
                stream.formatln("Failed in spec nr.      : %d", this.error.getSpecIndex());
                if (this.error.getModifierIndex() != -1) {
                    stream.formatln("Failed in modifier nr   : %d", this.error.getModifierIndex());
                }
            }
        }
    }

    @Override
    public String getTbsErrorMessage() {
        return this.tbsErrorMessage == null ? null : this.tbsErrorMessage.toString();
    }

    @Override
    public MethodParameterTraceEnableError getMptError() {
        return this.error;
    }

    @Override
    public String getMptErrorMessage() {
        return this.mptErrorMessage == null ? null : this.mptErrorMessage.toString();
    }

    @Override
    public List<MethodParameterSpec> getParameterSpecs() {
        return new ArrayList<MethodParameterSpec>(this.specs);
    }

    @Override
    public boolean includeCpuTime() {
        return this.includeCpuTime;
    }

    @Override
    public boolean includeStackTrace() {
        return this.includeStackTrace;
    }

    @Override
    public boolean includeStackTraceInExitEvents() {
        return this.includeStackTraceInExitEvents;
    }

    @Override
    public boolean includeTimeStamp() {
        return this.includeTimeStamp;
    }

    @Override
    public boolean smoothRequestedButFailed() {
        return this.smoothRequestedButFailed;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1038);
        this.writeInternal(writer);
        writer.writeBoolean(this.tbsErrorMessage == null);
        if (this.tbsErrorMessage != null) {
            writer.writeUTF(this.tbsErrorMessage);
        }
        writer.writeInt32(this.tbsConfiguration.getMaxStackTraceSize());
        writer.writeBoolean(this.tbsConfiguration.ignoreSleepingThreads());
        writer.writeThreadFilter(this.tbsConfiguration.getThreadFilter());
        writer.writeBoolean(this.mptErrorMessage == null);
        if (this.mptErrorMessage != null) {
            writer.writeUTF(this.mptErrorMessage);
        }
        writer.writeInt32(this.specs.size());
        writer.writeBoolean(this.includeTimeStamp);
        writer.writeBoolean(this.includeCpuTime);
        writer.writeBoolean(this.includeStackTrace);
        for (int i = 0; i < this.specs.size(); ++i) {
            MethodParameterSpecImpl spec = this.specs.get(i);
            writer.writeString(spec.getName());
            writer.writeString(spec.getDescription());
            writer.writeString(spec.getMethod());
            writer.writeInt8(spec.getIncludeType().getType());
            writer.writeInt32(spec.getIndex());
            writer.writeString(spec.getParameterType());
            List<String> modifiers = spec.getModifiers();
            writer.writeInt32(modifiers.size());
            for (String modifier : modifiers) {
                writer.writeString(modifier);
            }
        }
        if (this.mptErrorMessage != null) {
            writer.writeInt32(this.error.getType());
            writer.writeInt32(this.error.getSpecIndex());
            writer.writeInt32(this.error.getModifierIndex());
            writer.writeString(this.error.getMessage());
        }
        writer.writeNewThreadFilter(this.tbsConfiguration.getThreadFilter());
        writer.writeBoolean(this.tbsConfiguration.getSmooth());
        writer.writeBoolean(this.smoothRequestedButFailed);
        writer.writeBoolean(this.includeStackTraceInExitEvents);
        writer.finalizePacket();
    }
}

