/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.response;

import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.command.TimeBasedSamplingConfiguration;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class EnableTimeBasedSamplingResponseImpl
extends ResponseImpl
implements EnableTimeBasedSamplingResponse {
    private boolean smoothRequestedButFailed;
    private final TimeBasedSamplingConfiguration configuration = new TimeBasedSamplingConfiguration();

    public static EnableTimeBasedSamplingResponseImpl read(ResourceReader reader, MappingInformation mapInfo, ProfilingCapabilities capabilities, TimeBasedSamplingEventHandler[] handlers) throws IOException {
        EnableTimeBasedSamplingResponseImpl retValue = new EnableTimeBasedSamplingResponseImpl(reader, mapInfo, capabilities);
        for (TimeBasedSamplingEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableTimeBasedSamplingResponseImpl(ResourceReader reader, MappingInformation mapInfo, ProfilingCapabilities capabilities) throws IOException {
        super("enable time based sampling response", reader);
        mapInfo.setLastTbsTimeStamp(-1L);
        mapInfo.resetAverageTbsSampleDiff();
        this.configuration.setMaxStackTraceSize(reader.readInt32());
        this.configuration.setIgnoreSleepingThreads(reader.readBoolean());
        if (capabilities.hasThreadFilterInTimeBasedSampling()) {
            this.configuration.setThreadFilter(reader.readThreadFilter());
        } else if (!this.configuration.ignoreSleepingThreads()) {
            throw new UnsupportedOperationException("Sampling of sleeping threads is not supported by the profiled VM. In order to sample sleeping threads update the profiled VM to a current version.");
        }
        if (capabilities.hasAnnotationThreadFilter() && reader.hasNext()) {
            this.configuration.setThreadFilter(reader.readNewThreadFilter());
            if (reader.hasNext()) {
                this.configuration.setSmooth(reader.readBoolean());
            }
            if (reader.hasNext()) {
                this.smoothRequestedButFailed = reader.readBoolean();
            }
        }
    }

    @Override
    public TimeBasedSamplingConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_TIME_BASED_SAMPLING_RESPONSE;
    }

    @Override
    public boolean smoothRequestedButFailed() {
        return this.smoothRequestedButFailed;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        ThreadFilter threadFilter = this.configuration.getThreadFilter();
        stream.printlnResponseHeader(this);
        stream.formatln("Max stack trace size    : %d", this.configuration.getMaxStackTraceSize());
        stream.formatln("Ignore sleeping threads : %s", this.configuration.ignoreSleepingThreads());
        stream.formatln("Thread filter           : %s", threadFilter == null ? "**" : threadFilter.asString());
        stream.formatln("Smooth                  : %s", this.configuration.getSmooth());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1018);
        this.writeInternal(writer);
        writer.writeInt32(this.configuration.getMaxStackTraceSize());
        writer.writeBoolean(this.configuration.ignoreSleepingThreads());
        writer.writeThreadFilter(this.configuration.getThreadFilter());
        writer.writeNewThreadFilter(this.configuration.getThreadFilter());
        writer.writeBoolean(this.configuration.getSmooth());
        writer.writeBoolean(this.smoothRequestedButFailed);
        writer.finalizePacket();
    }
}

