/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.method.response;

import com.sap.jvm.profiling.method.response.MethodParameterIncludeType;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MethodParameterSpecImpl
implements MethodParameterSpec {
    private final int offset;
    private final String name;
    private final String description;
    private final String method;
    private final int index;
    private final MethodParameterIncludeType includeType;
    private final ArrayList<String> modifiers;
    private final String parameterType;

    public static MethodParameterSpecImpl read(ResourceReader reader) throws IOException {
        int offset = reader.readInt32();
        String specName = reader.readString();
        String description = reader.readString();
        String method = reader.readString();
        byte index = reader.readInt8();
        byte includeType = reader.readInt8();
        int nrOfModifiers = reader.readInt8();
        ArrayList<String> modifiers = new ArrayList<String>();
        for (int i = 0; i < nrOfModifiers; ++i) {
            modifiers.add(reader.readString());
        }
        String parameterType = reader.readString();
        return new MethodParameterSpecImpl(offset, specName, description, method, index, MethodParameterIncludeType.get(includeType), modifiers, parameterType);
    }

    public MethodParameterSpecImpl(int offset, String name, String description, String method, int index, MethodParameterIncludeType includeType, List<String> modifiers, String parameterType) {
        assert (index >= -2);
        this.offset = offset;
        this.name = name;
        this.description = description;
        this.method = method;
        this.index = index;
        this.includeType = includeType;
        this.modifiers = new ArrayList<String>(modifiers);
        this.parameterType = parameterType;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public List<String> getModifiers() {
        return new ArrayList<String>(this.modifiers);
    }

    @Override
    public MethodParameterIncludeType getIncludeType() {
        return this.includeType;
    }

    @Override
    public String getParameterType() {
        return this.parameterType;
    }

    public void write(PacketResourceWriter writer) throws IOException {
        boolean finalized = writer.isFinalized();
        if (finalized) {
            writer.initializePacket((short)412);
        }
        writer.writeInt32(this.offset);
        writer.writeString(this.name);
        writer.writeString(this.description);
        writer.writeString(this.method);
        writer.writeInt8(this.index);
        writer.writeInt8(this.includeType.getType());
        writer.writeInt8(this.modifiers.size());
        for (int i = 0; i < this.modifiers.size(); ++i) {
            writer.writeString(this.modifiers.get(i));
        }
        writer.writeString(this.parameterType);
        if (finalized) {
            writer.finalizePacket();
        }
    }
}

