/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.monitoring.event;

import com.sap.jvm.inspector.board.Attribute;
import com.sap.jvm.inspector.board.BoardDirectBufferImpl;
import com.sap.jvm.inspector.board.MonitorBoardFormatException;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractMonitoringBoardEventImpl
extends ProfilingPacketImpl {
    private final long timestamp;

    protected AbstractMonitoringBoardEventImpl(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public void print(ProfilingPrintStream stream, byte[] buffer, byte[] diff) {
        stream.printlnPacketHeader(this);
        if (buffer != null) {
            stream.formatln("BoardSize   : %d", buffer.length);
        }
        if (diff != null) {
            stream.formatln("DiffSize    : %d", diff.length);
        }
        stream.formatln("Timestamp   : %d", this.timestamp);
        if (buffer == null) {
            return;
        }
        BoardDirectBufferImpl board = new BoardDirectBufferImpl(buffer);
        HashMap<String, String> attributes = new HashMap<String, String>();
        Iterator<Attribute> it = board.getAttributeIterator();
        while (it.hasNext()) {
            Attribute attr = it.next();
            String name = null;
            String value = null;
            try {
                name = attr.getName();
                value = attr.isArray() ? Arrays.toString(attr.getValues()) : attr.getValue().getAsString();
            }
            catch (MonitorBoardFormatException e) {
                value = "<unknown>";
            }
            if (name == null) continue;
            attributes.put(name, value);
        }
        ArrayList keys = new ArrayList(attributes.keySet());
        Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
        for (String key : keys) {
            stream.println(key + " : " + (String)attributes.get(key));
        }
    }

    protected byte[] applyDiff(byte[] diff, byte[] board) {
        int pos = 0;
        int i = 0;
        while (i < diff.length) {
            int c = diff[i] & 0xFF;
            ++i;
            if (c == 0) {
                c = diff[i] & 0xFF;
                ++i;
                if (c == 0) {
                    c = diff[i] & 0xFF;
                    ++i;
                    if (c == 0) {
                        pos += (diff[i] & 0xFF) * 65536;
                        pos += (diff[i + 1] & 0xFF) * 256;
                        pos += diff[i + 2] & 0xFF;
                        i += 3;
                        continue;
                    }
                    pos += c * 256;
                    pos += diff[i] & 0xFF;
                    ++i;
                    continue;
                }
                pos += c;
                continue;
            }
            int n = pos++;
            board[n] = (byte)(board[n] ^ c);
        }
        return board;
    }
}

