/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.monitoring.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.impl.monitoring.event.AbstractMonitoringBoardEventImpl;
import com.sap.jvm.profiling.monitoring.event.MonitoringBoardEvent;
import com.sap.jvm.profiling.monitoring.event.MonitoringEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MonitoringBoardDiffToInitialEventImpl
extends AbstractMonitoringBoardEventImpl
implements MonitoringBoardEvent {
    private final byte[] initialBuffer;
    private final byte[] diff;

    public static MonitoringBoardDiffToInitialEventImpl read(ResourceReader reader, byte[] initialBoard, MonitoringEventHandler[] handlers) throws IOException {
        MonitoringBoardDiffToInitialEventImpl result = new MonitoringBoardDiffToInitialEventImpl(reader, initialBoard);
        for (MonitoringEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public MonitoringBoardDiffToInitialEventImpl(ResourceReader reader, byte[] initialBoard) throws IOException {
        super(reader.readInt64());
        this.diff = reader.readRemainingBytes();
        this.initialBuffer = initialBoard;
    }

    public MonitoringBoardDiffToInitialEventImpl(long timestamp, byte[] curr, byte[] initial) {
        super(timestamp);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int first_nondiff_pos = 0;
        for (int i = 0; i < curr.length; ++i) {
            if (curr[i] == initial[i]) continue;
            int offset = i - first_nondiff_pos;
            if (offset > 0) {
                if (offset >= 256) {
                    if (offset >= 65536) {
                        bos.write(0);
                        bos.write(0);
                        bos.write(0);
                        bos.write(offset / 65536);
                        bos.write(offset / 256 & 0xFF);
                        bos.write(offset & 0xFF);
                    } else {
                        bos.write(0);
                        bos.write(0);
                        bos.write(offset / 256);
                        bos.write(offset & 0xFF);
                    }
                } else {
                    bos.write(0);
                    bos.write(offset);
                }
            }
            bos.write(curr[i] ^ initial[i]);
            first_nondiff_pos = i + 1;
        }
        this.diff = bos.toByteArray();
        this.initialBuffer = initial;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.MONITORING_BOARD_CONTENT_EVENT;
    }

    @Override
    public String getPacketName() {
        return "monitoring board diff to initial content event";
    }

    @Override
    public void print(PrintStream stream, boolean includeContent) {
        SimpleProfilingPrintStream sps = new SimpleProfilingPrintStream(stream);
        this.print(sps, includeContent);
        sps.flush();
    }

    @Override
    public void print(ProfilingPrintStream stream, boolean includeContent) {
        this.print(stream, includeContent ? this.applyDiff(this.diff, (byte[])this.initialBuffer.clone()) : null, this.diff);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        this.print(stream, false);
    }

    @Override
    public byte[] getContent() {
        return this.applyDiff(this.diff, (byte[])this.initialBuffer.clone());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)763);
        writer.writeInt64(this.getTimeStamp());
        writer.writeBytes(this.diff);
        writer.finalizePacket();
    }
}

