/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.monitoring.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.impl.monitoring.event.AbstractMonitoringBoardEventImpl;
import com.sap.jvm.profiling.monitoring.event.MonitoringBoardDiffEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.io.PrintStream;

public class MonitoringBoardDiffToPrevEventImpl
extends AbstractMonitoringBoardEventImpl
implements MonitoringBoardDiffEvent {
    private final byte[] diff;

    public MonitoringBoardDiffToPrevEventImpl(ResourceReader reader) throws IOException {
        super(reader.readInt64());
        this.diff = reader.readRemainingBytes();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.MONITORING_BOARD_DIFFERENCE_EVENT;
    }

    @Override
    public String getPacketName() {
        return "monitoring board diff to previous content event";
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("DiffSize    : %d", this.diff.length);
    }

    @Override
    public final void print(PrintStream stream, byte[] lastBoard) {
        SimpleProfilingPrintStream sps = new SimpleProfilingPrintStream(stream);
        this.print(sps, lastBoard);
        sps.flush();
    }

    @Override
    public void print(ProfilingPrintStream stream, byte[] lastBoard) {
        byte[] board = this.applyDiff((byte[])lastBoard.clone());
        this.print(stream, board, this.diff);
    }

    @Override
    public byte[] applyDiff(byte[] board) {
        return this.applyDiff(this.diff, board);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)762);
        writer.writeInt64(this.getTimeStamp());
        writer.writeBytes(this.diff);
        writer.finalizePacket();
    }
}

