/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.monitoring.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.impl.monitoring.event.AbstractMonitoringBoardEventImpl;
import com.sap.jvm.profiling.monitoring.event.MonitoringBoardEvent;
import com.sap.jvm.profiling.monitoring.event.MonitoringEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.io.PrintStream;

public class MonitoringBoardInitialEventImpl
extends AbstractMonitoringBoardEventImpl
implements MonitoringBoardEvent {
    private final byte[] buffer;

    public static MonitoringBoardInitialEventImpl read(ResourceReader reader, MonitoringEventHandler[] handlers) throws IOException {
        MonitoringBoardInitialEventImpl result = new MonitoringBoardInitialEventImpl(reader);
        for (MonitoringEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public MonitoringBoardInitialEventImpl(ResourceReader reader) throws IOException {
        super(reader.readInt64());
        int boardSize = reader.readInt32();
        this.buffer = new byte[boardSize];
        reader.readBytes(this.buffer);
    }

    public MonitoringBoardInitialEventImpl(byte[] board, long timestamp) throws IOException {
        super(timestamp);
        this.buffer = board;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.MONITORING_BOARD_CONTENT_EVENT;
    }

    @Override
    public String getPacketName() {
        return "monitoring board initial content event";
    }

    @Override
    public void print(PrintStream stream, boolean includeContent) {
        SimpleProfilingPrintStream sps = new SimpleProfilingPrintStream(stream);
        this.print(sps, includeContent);
        sps.flush();
    }

    @Override
    public void print(ProfilingPrintStream stream, boolean includeContent) {
        this.print(stream, includeContent ? this.buffer : null, null);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        this.print(stream, false);
    }

    @Override
    public byte[] getContent() {
        return this.buffer;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        int toWrite;
        writer.initializePacket((short)761);
        writer.writeInt64(this.getTimeStamp());
        writer.writeInt32(this.buffer.length);
        int off = 0;
        for (int left = this.buffer.length; left > 0; left -= toWrite) {
            toWrite = Math.min(left, 32768);
            writer.writeBytes(this.buffer, off, toWrite);
            off += toWrite;
        }
        writer.finalizePacket();
    }
}

