/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.monitoring.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.monitoring.event.MonitoringEventHandler;
import com.sap.jvm.profiling.monitoring.response.EnableMonitoringBoardTraceResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class EnableMonitoringBoardTraceResponseImpl
extends ResponseImpl
implements EnableMonitoringBoardTraceResponse {
    private final boolean onlyFirst;
    private final int fullInterval;
    private final int updateInterval;

    public static EnableMonitoringBoardTraceResponseImpl read(ResourceReader reader, MonitoringEventHandler[] handlers) throws IOException {
        EnableMonitoringBoardTraceResponseImpl retValue = new EnableMonitoringBoardTraceResponseImpl(reader);
        for (MonitoringEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableMonitoringBoardTraceResponseImpl(ResourceReader reader) throws IOException {
        super("enable monitoring board trace response", reader);
        this.onlyFirst = reader.readBoolean();
        if (reader.hasNext()) {
            this.fullInterval = reader.readInt32();
            this.updateInterval = reader.readInt32();
        } else {
            this.fullInterval = 0;
            this.updateInterval = 60000;
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_MONITORING_BOARD_TRACE_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.formatln("onlyFirst      : %s", this.onlyFirst());
        stream.formatln("fullInterval   : %s", this.getFullInterval());
        stream.formatln("updateInterval : %s", this.getUpdateInterval());
    }

    @Override
    public boolean onlyFirst() {
        return this.onlyFirst;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1066);
        this.writeInternal(writer);
        writer.writeBoolean(this.onlyFirst);
        writer.writeInt32(this.fullInterval);
        writer.writeInt32(this.updateInterval);
        writer.finalizePacket();
    }

    @Override
    public int getFullInterval() {
        return this.fullInterval;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }
}

